/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java.spi;

import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.function.Function;
import java.util.function.Supplier;
import org.hibernate.annotations.Immutable;
import org.hibernate.annotations.Mutability;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.type.descriptor.java.EnumJavaType;
import org.hibernate.type.descriptor.java.ImmutableMutabilityPlan;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.MutabilityPlan;
import org.hibernate.type.descriptor.java.SerializableJavaType;
import org.hibernate.type.descriptor.java.spi.UnknownBasicJavaType;
import org.hibernate.type.spi.TypeConfiguration;

public class RegistryHelper {
    public static final RegistryHelper INSTANCE = new RegistryHelper();

    private RegistryHelper() {
    }

    public <J> JavaType<J> createTypeDescriptor(Type javaType, Supplier<MutabilityPlan<J>> fallbackMutabilityPlanResolver, TypeConfiguration typeConfiguration) {
        return this.createTypeDescriptor(javaType, javaTypeClass -> {
            MutabilityPlan mutabilityPlan = this.determineMutabilityPlan(javaType, typeConfiguration);
            if (mutabilityPlan == null) {
                mutabilityPlan = (MutabilityPlan)fallbackMutabilityPlanResolver.get();
            }
            return mutabilityPlan;
        });
    }

    public <J> MutabilityPlan<J> determineMutabilityPlan(Type javaType, TypeConfiguration typeConfiguration) {
        Class<J> javaTypeClass = this.determineJavaTypeClass(javaType);
        if (javaTypeClass.isAnnotationPresent(Immutable.class)) {
            return ImmutableMutabilityPlan.instance();
        }
        if (javaTypeClass.isAnnotationPresent(Mutability.class)) {
            Mutability annotation = javaTypeClass.getAnnotation(Mutability.class);
            return typeConfiguration.createMutabilityPlan(annotation.value());
        }
        if (javaTypeClass.isEnum() || javaTypeClass.isPrimitive() || ReflectHelper.isRecord(javaTypeClass)) {
            return ImmutableMutabilityPlan.instance();
        }
        if (Serializable.class.isAssignableFrom(javaTypeClass)) {
            return SerializableJavaType.SerializableMutabilityPlan.INSTANCE;
        }
        return null;
    }

    private <J> JavaType<J> createTypeDescriptor(Type javaType, Function<Class<J>, MutabilityPlan<J>> mutabilityPlanResolver) {
        Class<J> javaTypeClass = this.determineJavaTypeClass(javaType);
        if (javaTypeClass.isEnum()) {
            return new EnumJavaType<J>(javaTypeClass);
        }
        MutabilityPlan<J> plan = mutabilityPlanResolver.apply(javaTypeClass);
        if (Serializable.class.isAssignableFrom(javaTypeClass)) {
            return new SerializableJavaType<J>(javaTypeClass, plan);
        }
        return new UnknownBasicJavaType<J>(javaType, plan);
    }

    private <J> Class<J> determineJavaTypeClass(Type javaType) {
        return ReflectHelper.getClass(javaType);
    }
}

