/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.schema.internal;

import java.sql.Connection;
import java.util.Map;
import org.hibernate.boot.model.relational.SqlStringGenerationContext;
import org.hibernate.boot.registry.selector.spi.StrategySelector;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.connections.spi.JdbcConnectionAccess;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolver;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.jdbc.spi.SqlExceptionHelper;
import org.hibernate.engine.jdbc.spi.SqlStatementLogger;
import org.hibernate.internal.log.DeprecationLogger;
import org.hibernate.internal.util.NullnessHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.resource.transaction.spi.DdlTransactionIsolator;
import org.hibernate.resource.transaction.spi.TransactionCoordinatorBuilder;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.spi.ServiceRegistryAwareService;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.tool.schema.JdbcMetadaAccessStrategy;
import org.hibernate.tool.schema.TargetType;
import org.hibernate.tool.schema.extract.internal.InformationExtractorJdbcDatabaseMetaDataImpl;
import org.hibernate.tool.schema.extract.spi.ExtractionContext;
import org.hibernate.tool.schema.extract.spi.InformationExtractor;
import org.hibernate.tool.schema.internal.DdlTransactionIsolatorProvidedConnectionImpl;
import org.hibernate.tool.schema.internal.DefaultSchemaFilterProvider;
import org.hibernate.tool.schema.internal.GroupedSchemaMigratorImpl;
import org.hibernate.tool.schema.internal.GroupedSchemaValidatorImpl;
import org.hibernate.tool.schema.internal.IndividuallySchemaMigratorImpl;
import org.hibernate.tool.schema.internal.IndividuallySchemaValidatorImpl;
import org.hibernate.tool.schema.internal.SchemaCreatorImpl;
import org.hibernate.tool.schema.internal.SchemaDropperImpl;
import org.hibernate.tool.schema.internal.SchemaPopulatorImpl;
import org.hibernate.tool.schema.internal.SchemaTruncatorImpl;
import org.hibernate.tool.schema.internal.exec.GenerationTargetToDatabase;
import org.hibernate.tool.schema.internal.exec.GenerationTargetToScript;
import org.hibernate.tool.schema.internal.exec.GenerationTargetToStdout;
import org.hibernate.tool.schema.internal.exec.ImprovedExtractionContextImpl;
import org.hibernate.tool.schema.internal.exec.JdbcConnectionAccessProvidedConnectionImpl;
import org.hibernate.tool.schema.internal.exec.JdbcContext;
import org.hibernate.tool.schema.spi.ExtractionTool;
import org.hibernate.tool.schema.spi.GenerationTarget;
import org.hibernate.tool.schema.spi.SchemaCreator;
import org.hibernate.tool.schema.spi.SchemaDropper;
import org.hibernate.tool.schema.spi.SchemaFilter;
import org.hibernate.tool.schema.spi.SchemaFilterProvider;
import org.hibernate.tool.schema.spi.SchemaManagementException;
import org.hibernate.tool.schema.spi.SchemaManagementTool;
import org.hibernate.tool.schema.spi.SchemaMigrator;
import org.hibernate.tool.schema.spi.SchemaPopulator;
import org.hibernate.tool.schema.spi.SchemaTruncator;
import org.hibernate.tool.schema.spi.SchemaValidator;
import org.hibernate.tool.schema.spi.TargetDescriptor;
import org.jboss.logging.Logger;

public class HibernateSchemaManagementTool
implements SchemaManagementTool,
ServiceRegistryAwareService {
    private static final Logger log = Logger.getLogger(HibernateSchemaManagementTool.class);
    private ServiceRegistry serviceRegistry;
    private GenerationTarget customTarget;

    @Override
    public void injectServices(ServiceRegistryImplementor serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    @Override
    public SchemaCreator getSchemaCreator(Map<String, Object> options) {
        return new SchemaCreatorImpl(this, this.getSchemaFilterProvider(options).getCreateFilter());
    }

    @Override
    public SchemaDropper getSchemaDropper(Map<String, Object> options) {
        return new SchemaDropperImpl(this, this.getSchemaFilterProvider(options).getDropFilter());
    }

    @Override
    public SchemaTruncator getSchemaTruncator(Map<String, Object> options) {
        return new SchemaTruncatorImpl(this, this.getSchemaFilterProvider(options).getTruncatorFilter());
    }

    @Override
    public SchemaPopulator getSchemaPopulator(Map<String, Object> options) {
        return new SchemaPopulatorImpl(this);
    }

    @Override
    public SchemaMigrator getSchemaMigrator(Map<String, Object> options) {
        SchemaFilter migrateFilter = this.getSchemaFilterProvider(options).getMigrateFilter();
        return this.determineJdbcMetadaAccessStrategy(options) == JdbcMetadaAccessStrategy.GROUPED ? new GroupedSchemaMigratorImpl(this, migrateFilter) : new IndividuallySchemaMigratorImpl(this, migrateFilter);
    }

    @Override
    public SchemaValidator getSchemaValidator(Map<String, Object> options) {
        SchemaFilter validateFilter = this.getSchemaFilterProvider(options).getValidateFilter();
        return this.determineJdbcMetadaAccessStrategy(options) == JdbcMetadaAccessStrategy.GROUPED ? new GroupedSchemaValidatorImpl(this, validateFilter) : new IndividuallySchemaValidatorImpl(this, validateFilter);
    }

    private SchemaFilterProvider getSchemaFilterProvider(Map<String, Object> options) {
        return this.serviceRegistry.requireService(StrategySelector.class).resolveDefaultableStrategy(SchemaFilterProvider.class, options == null ? null : options.get("hibernate.hbm2ddl.schema_filter_provider"), DefaultSchemaFilterProvider.INSTANCE);
    }

    private JdbcMetadaAccessStrategy determineJdbcMetadaAccessStrategy(Map<String, Object> options) {
        return JdbcMetadaAccessStrategy.interpretSetting(options);
    }

    @Override
    public void setCustomDatabaseGenerationTarget(GenerationTarget generationTarget) {
        this.customTarget = generationTarget;
    }

    @Override
    public ExtractionTool getExtractionTool() {
        return HibernateExtractionTool.INSTANCE;
    }

    GenerationTarget getCustomDatabaseGenerationTarget() {
        return this.customTarget;
    }

    @Override
    public GenerationTarget[] buildGenerationTargets(TargetDescriptor targetDescriptor, JdbcContext jdbcContext, Map<String, Object> options, boolean needsAutoCommit) {
        String scriptDelimiter = ConfigurationHelper.getString("hibernate.hbm2ddl.delimiter", options, ";");
        GenerationTarget[] targets = new GenerationTarget[targetDescriptor.getTargetTypes().size()];
        int index = 0;
        if (targetDescriptor.getTargetTypes().contains((Object)TargetType.STDOUT)) {
            targets[index] = this.buildStdoutTarget(scriptDelimiter);
            ++index;
        }
        if (targetDescriptor.getTargetTypes().contains((Object)TargetType.SCRIPT)) {
            if (targetDescriptor.getScriptTargetOutput() == null) {
                throw new SchemaManagementException("Writing to script was requested, but no script file was specified");
            }
            targets[index] = this.buildScriptTarget(targetDescriptor, scriptDelimiter);
            ++index;
        }
        if (targetDescriptor.getTargetTypes().contains((Object)TargetType.DATABASE)) {
            targets[index] = this.customTarget == null ? this.buildDatabaseTarget(jdbcContext, needsAutoCommit) : this.customTarget;
            ++index;
        }
        return targets;
    }

    protected GenerationTarget buildStdoutTarget(String scriptDelimiter) {
        return new GenerationTargetToStdout(scriptDelimiter);
    }

    protected GenerationTarget buildScriptTarget(TargetDescriptor targetDescriptor, String scriptDelimiter) {
        return new GenerationTargetToScript(targetDescriptor.getScriptTargetOutput(), scriptDelimiter);
    }

    protected GenerationTarget buildDatabaseTarget(JdbcContext jdbcContext, boolean needsAutoCommit) {
        return new GenerationTargetToDatabase(this.getDdlTransactionIsolator(jdbcContext), true, needsAutoCommit);
    }

    GenerationTarget[] buildGenerationTargets(TargetDescriptor targetDescriptor, DdlTransactionIsolator ddlTransactionIsolator, Map<String, Object> options) {
        String scriptDelimiter = ConfigurationHelper.getString("hibernate.hbm2ddl.delimiter", options, ";");
        GenerationTarget[] targets = new GenerationTarget[targetDescriptor.getTargetTypes().size()];
        int index = 0;
        if (targetDescriptor.getTargetTypes().contains((Object)TargetType.STDOUT)) {
            targets[index] = this.buildStdoutTarget(scriptDelimiter);
            ++index;
        }
        if (targetDescriptor.getTargetTypes().contains((Object)TargetType.SCRIPT)) {
            if (targetDescriptor.getScriptTargetOutput() == null) {
                throw new SchemaManagementException("Writing to script was requested, but no script file was specified");
            }
            targets[index] = this.buildScriptTarget(targetDescriptor, scriptDelimiter);
            ++index;
        }
        if (targetDescriptor.getTargetTypes().contains((Object)TargetType.DATABASE)) {
            targets[index] = this.customTarget == null ? new GenerationTargetToDatabase(ddlTransactionIsolator, false) : this.customTarget;
            ++index;
        }
        return targets;
    }

    public DdlTransactionIsolator getDdlTransactionIsolator(JdbcContext jdbcContext) {
        if (jdbcContext.getJdbcConnectionAccess() instanceof JdbcConnectionAccessProvidedConnectionImpl) {
            return new DdlTransactionIsolatorProvidedConnectionImpl(jdbcContext);
        }
        return this.serviceRegistry.requireService(TransactionCoordinatorBuilder.class).buildDdlTransactionIsolator(jdbcContext);
    }

    public JdbcContext resolveJdbcContext(final Map<String, Object> configurationValues) {
        String dbName;
        JdbcContextBuilder jdbcContextBuilder = new JdbcContextBuilder(this.serviceRegistry);
        Connection providedConnection = (Connection)NullnessHelper.coalesceSuppliedValues(() -> configurationValues.get("jakarta.persistence.schema-generation-connection"), () -> {
            Object value = configurationValues.get("javax.persistence.schema-generation-connection");
            if (value != null) {
                DeprecationLogger.DEPRECATION_LOGGER.deprecatedSetting("javax.persistence.schema-generation-connection", "jakarta.persistence.schema-generation-connection");
            }
            return value;
        });
        if (providedConnection != null) {
            jdbcContextBuilder.jdbcConnectionAccess = new JdbcConnectionAccessProvidedConnectionImpl(providedConnection);
        }
        if ((dbName = (String)NullnessHelper.coalesceSuppliedValues(() -> configurationValues.get("jakarta.persistence.database-product-name"), () -> {
            String name = (String)configurationValues.get("javax.persistence.database-product-name");
            if (StringHelper.isNotEmpty(name)) {
                DeprecationLogger.DEPRECATION_LOGGER.deprecatedSetting("javax.persistence.database-product-name", "jakarta.persistence.database-product-name");
            }
            return name;
        })) != null) {
            final String dbVersion = (String)NullnessHelper.coalesceSuppliedValues(() -> configurationValues.get("jakarta.persistence.database-product-version"), () -> {
                String name = (String)configurationValues.get("javax.persistence.database-product-version");
                if (StringHelper.isNotEmpty(name)) {
                    DeprecationLogger.DEPRECATION_LOGGER.deprecatedSetting("javax.persistence.database-product-version", "jakarta.persistence.database-product-version");
                }
                return name;
            });
            final String dbMajor = (String)NullnessHelper.coalesceSuppliedValues(() -> configurationValues.get("jakarta.persistence.database-major-version"), () -> {
                String name = (String)configurationValues.get("javax.persistence.database-major-version");
                if (StringHelper.isNotEmpty(name)) {
                    DeprecationLogger.DEPRECATION_LOGGER.deprecatedSetting("javax.persistence.database-major-version", "jakarta.persistence.database-major-version");
                }
                return name;
            });
            final String dbMinor = (String)NullnessHelper.coalesceSuppliedValues(() -> configurationValues.get("jakarta.persistence.database-minor-version"), () -> {
                String name = (String)configurationValues.get("javax.persistence.database-minor-version");
                if (StringHelper.isNotEmpty(name)) {
                    DeprecationLogger.DEPRECATION_LOGGER.deprecatedSetting("javax.persistence.database-minor-version", "jakarta.persistence.database-minor-version");
                }
                return name;
            });
            Dialect indicatedDialect = this.serviceRegistry.requireService(DialectResolver.class).resolveDialect(new DialectResolutionInfo(){

                @Override
                public String getDatabaseName() {
                    return dbName;
                }

                @Override
                public String getDatabaseVersion() {
                    return dbVersion == null ? String.valueOf(-9999) : dbVersion;
                }

                @Override
                public int getDatabaseMajorVersion() {
                    return StringHelper.isEmpty(dbMajor) ? -9999 : Integer.parseInt(dbMajor);
                }

                @Override
                public int getDatabaseMinorVersion() {
                    return StringHelper.isEmpty(dbMinor) ? -9999 : Integer.parseInt(dbMinor);
                }

                @Override
                public String getDriverName() {
                    return null;
                }

                @Override
                public int getDriverMajorVersion() {
                    return -9999;
                }

                @Override
                public int getDriverMinorVersion() {
                    return -9999;
                }

                @Override
                public String getSQLKeywords() {
                    return "";
                }

                @Override
                public Map<String, Object> getConfigurationValues() {
                    return configurationValues;
                }
            });
            if (indicatedDialect == null) {
                log.debugf("Unable to resolve indicated Dialect resolution info (%s, %s, %s)", (Object)dbName, (Object)dbMajor, (Object)dbMinor);
            } else {
                jdbcContextBuilder.dialect = indicatedDialect;
            }
        }
        return jdbcContextBuilder.buildJdbcContext();
    }

    public ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    private static class HibernateExtractionTool
    implements ExtractionTool {
        private static final HibernateExtractionTool INSTANCE = new HibernateExtractionTool();

        private HibernateExtractionTool() {
        }

        @Override
        public ExtractionContext createExtractionContext(ServiceRegistry serviceRegistry, JdbcEnvironment jdbcEnvironment, SqlStringGenerationContext context, DdlTransactionIsolator ddlTransactionIsolator, ExtractionContext.DatabaseObjectAccess databaseObjectAccess) {
            return new ImprovedExtractionContextImpl(serviceRegistry, jdbcEnvironment, context, ddlTransactionIsolator, databaseObjectAccess);
        }

        @Override
        public InformationExtractor createInformationExtractor(ExtractionContext extractionContext) {
            return new InformationExtractorJdbcDatabaseMetaDataImpl(extractionContext);
        }
    }

    private static class JdbcContextBuilder {
        private final ServiceRegistry serviceRegistry;
        private final SqlStatementLogger sqlStatementLogger;
        private final SqlExceptionHelper sqlExceptionHelper;
        private JdbcConnectionAccess jdbcConnectionAccess;
        private Dialect dialect;

        public JdbcContextBuilder(ServiceRegistry serviceRegistry) {
            this.serviceRegistry = serviceRegistry;
            JdbcServices jdbcServices = serviceRegistry.requireService(JdbcServices.class);
            this.sqlStatementLogger = jdbcServices.getSqlStatementLogger();
            this.sqlExceptionHelper = jdbcServices.getSqlExceptionHelper();
            this.dialect = jdbcServices.getJdbcEnvironment().getDialect();
            this.jdbcConnectionAccess = jdbcServices.getBootstrapJdbcConnectionAccess();
        }

        public JdbcContext buildJdbcContext() {
            return new JdbcContextImpl(this.jdbcConnectionAccess, this.dialect, this.sqlStatementLogger, this.sqlExceptionHelper, this.serviceRegistry);
        }
    }

    public static class JdbcContextImpl
    implements JdbcContext {
        private final JdbcConnectionAccess jdbcConnectionAccess;
        private final Dialect dialect;
        private final SqlStatementLogger sqlStatementLogger;
        private final SqlExceptionHelper sqlExceptionHelper;
        private final ServiceRegistry serviceRegistry;

        private JdbcContextImpl(JdbcConnectionAccess jdbcConnectionAccess, Dialect dialect, SqlStatementLogger sqlStatementLogger, SqlExceptionHelper sqlExceptionHelper, ServiceRegistry serviceRegistry) {
            this.jdbcConnectionAccess = jdbcConnectionAccess;
            this.dialect = dialect;
            this.sqlStatementLogger = sqlStatementLogger;
            this.sqlExceptionHelper = sqlExceptionHelper;
            this.serviceRegistry = serviceRegistry;
        }

        @Override
        public JdbcConnectionAccess getJdbcConnectionAccess() {
            return this.jdbcConnectionAccess;
        }

        @Override
        public Dialect getDialect() {
            return this.dialect;
        }

        @Override
        public SqlStatementLogger getSqlStatementLogger() {
            return this.sqlStatementLogger;
        }

        @Override
        public SqlExceptionHelper getSqlExceptionHelper() {
            return this.sqlExceptionHelper;
        }

        @Override
        public ServiceRegistry getServiceRegistry() {
            return this.serviceRegistry;
        }
    }
}

