/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.collection.internal;

import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.collection.spi.CollectionSemantics;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.CollectionKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.CollectionClassification;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.Initializer;
import org.hibernate.sql.results.graph.InitializerData;
import org.hibernate.sql.results.graph.InitializerParent;
import org.hibernate.sql.results.graph.collection.LoadingCollectionEntry;
import org.hibernate.sql.results.graph.collection.internal.AbstractCollectionInitializer;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;

public abstract class AbstractNonJoinCollectionInitializer<Data extends AbstractCollectionInitializer.CollectionInitializerData>
extends AbstractCollectionInitializer<Data> {
    public AbstractNonJoinCollectionInitializer(NavigablePath collectionPath, PluralAttributeMapping collectionAttributeMapping, InitializerParent<?> parent, @Nullable DomainResult<?> collectionKeyResult, boolean isResultInitializer, AssemblerCreationState creationState) {
        super(collectionPath, collectionAttributeMapping, parent, collectionKeyResult, isResultInitializer, creationState);
    }

    @Override
    protected void resolveInstance(Data data, boolean isEager) {
        if (((InitializerData)data).getState() != Initializer.State.KEY_RESOLVED) {
            return;
        }
        this.resolveCollectionKey(data, false);
        if (((InitializerData)data).getState() == Initializer.State.KEY_RESOLVED) {
            assert (this.owningEntityInitializer != null);
            RowProcessingState rowProcessingState = ((InitializerData)data).getRowProcessingState();
            Object owningEntityData = this.owningEntityInitializer.getData(rowProcessingState);
            if (((InitializerData)owningEntityData).getState() == Initializer.State.INITIALIZED) {
                ((InitializerData)data).setState(Initializer.State.MISSING);
                return;
            }
            ((InitializerData)data).setState(Initializer.State.INITIALIZED);
            SharedSessionContractImplementor session = rowProcessingState.getSession();
            PersistenceContext persistenceContext = session.getPersistenceContextInternal();
            CollectionKey collectionKey = ((AbstractCollectionInitializer.CollectionInitializerData)data).collectionKey;
            assert (collectionKey != null);
            LoadingCollectionEntry loadingEntry = persistenceContext.getLoadContexts().findLoadingCollectionEntry(collectionKey);
            if (loadingEntry != null) {
                PersistentCollection<?> collectionInstance = loadingEntry.getCollectionInstance();
                ((AbstractCollectionInitializer.CollectionInitializerData)data).setCollectionInstance(collectionInstance);
                if (collectionInstance.getOwner() == null) {
                    assert (this.owningEntityInitializer.getTargetInstance(owningEntityData) != null);
                    collectionInstance.setOwner(this.owningEntityInitializer.getTargetInstance(owningEntityData));
                }
                return;
            }
            PersistentCollection<?> existing = persistenceContext.getCollection(collectionKey);
            if (existing != null) {
                ((AbstractCollectionInitializer.CollectionInitializerData)data).setCollectionInstance(existing);
                if (existing.getOwner() == null) {
                    assert (this.owningEntityInitializer.getTargetInstance(owningEntityData) != null);
                    existing.setOwner(this.owningEntityInitializer.getTargetInstance(owningEntityData));
                }
                return;
            }
            CollectionPersister collectionDescriptor = this.collectionAttributeMapping.getCollectionDescriptor();
            CollectionSemantics<?, ?> collectionSemantics = collectionDescriptor.getCollectionSemantics();
            Object key = collectionKey.getKey();
            PersistentCollection<?> persistentCollection = collectionSemantics.instantiateWrapper(key, collectionDescriptor, session);
            ((AbstractCollectionInitializer.CollectionInitializerData)data).setCollectionInstance(persistentCollection);
            assert (this.owningEntityInitializer.getTargetInstance(owningEntityData) != null);
            persistentCollection.setOwner(this.owningEntityInitializer.getTargetInstance(owningEntityData));
            persistenceContext.addUninitializedCollection(collectionDescriptor, persistentCollection, key);
            if (isEager) {
                persistenceContext.addNonLazyCollection(persistentCollection);
            }
            if (collectionSemantics.getCollectionClassification() == CollectionClassification.ARRAY) {
                persistenceContext.addCollectionHolder(persistentCollection);
            }
        }
    }

    protected void resolveInstance(Object instance, Data data, boolean isEager) {
        if (instance == null) {
            this.setMissing(data);
        } else {
            RowProcessingState rowProcessingState = ((InitializerData)data).getRowProcessingState();
            PersistenceContext persistenceContext = rowProcessingState.getSession().getPersistenceContextInternal();
            PersistentCollection<?> persistentCollection = this.collectionAttributeMapping.getCollectionDescriptor().getCollectionSemantics().getCollectionClassification() == CollectionClassification.ARRAY ? persistenceContext.getCollectionHolder(instance) : (PersistentCollection<?>)instance;
            ((AbstractCollectionInitializer.CollectionInitializerData)data).setCollectionInstance(persistentCollection);
            ((InitializerData)data).setState(Initializer.State.INITIALIZED);
            if (isEager && !persistentCollection.wasInitialized()) {
                persistenceContext.addNonLazyCollection(persistentCollection);
            }
            if (this.collectionKeyResultAssembler != null && rowProcessingState.needsResolveState()) {
                this.collectionKeyResultAssembler.resolveState(rowProcessingState);
            }
        }
    }
}

