/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.model.ast.builder;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import org.hibernate.metamodel.mapping.SelectableConsumer;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.mutation.EntityMutationTarget;
import org.hibernate.sql.model.MutationType;
import org.hibernate.sql.model.ast.MutationGroup;
import org.hibernate.sql.model.ast.TableMutation;
import org.hibernate.sql.model.ast.builder.ColumnValuesTableMutationBuilder;
import org.hibernate.sql.model.ast.builder.TableMutationBuilder;
import org.hibernate.sql.model.internal.MutationGroupNone;
import org.hibernate.sql.model.internal.MutationGroupSingle;
import org.hibernate.sql.model.internal.MutationGroupStandard;

public class MutationGroupBuilder
implements SelectableConsumer {
    private final MutationType mutationType;
    private final EntityMutationTarget mutationTarget;
    private final Map<String, TableMutationBuilder<?>> tableMutationBuilderMap;

    public MutationGroupBuilder(MutationType mutationType, EntityMutationTarget mutationTarget) {
        this.mutationType = mutationType;
        this.mutationTarget = mutationTarget;
        this.tableMutationBuilderMap = new LinkedHashMap();
    }

    public MutationType getMutationType() {
        return this.mutationType;
    }

    public EntityMutationTarget getMutationTarget() {
        return this.mutationTarget;
    }

    public <B extends TableMutationBuilder<?>> B findTableDetailsBuilder(String name) {
        return (B)this.tableMutationBuilderMap.get(name);
    }

    public <B extends TableMutationBuilder<?>> B getTableDetailsBuilder(String name) {
        B builder = this.findTableDetailsBuilder(name);
        if (builder == null) {
            throw new RuntimeException("Expecting already existing TableMutationBuilder : " + name);
        }
        return builder;
    }

    public void addTableDetailsBuilder(TableMutationBuilder<?> builder) {
        this.tableMutationBuilderMap.put(builder.getMutatingTable().getTableName(), builder);
    }

    public void forEachTableMutationBuilder(Consumer<TableMutationBuilder<?>> consumer) {
        this.tableMutationBuilderMap.forEach((name, mutationBuilder) -> consumer.accept((TableMutationBuilder<?>)mutationBuilder));
    }

    @Override
    public void accept(int selectionIndex, SelectableMapping selectableMapping) {
        EntityPersister entityPersister = this.mutationTarget.getTargetPart().getEntityPersister();
        String tableNameForMutation = entityPersister.physicalTableNameForMutation(selectableMapping);
        ColumnValuesTableMutationBuilder mutationBuilder = (ColumnValuesTableMutationBuilder)this.findTableDetailsBuilder(tableNameForMutation);
        mutationBuilder.addValueColumn(selectableMapping);
    }

    public MutationGroup buildMutationGroup() {
        if (this.tableMutationBuilderMap.isEmpty()) {
            throw new IllegalStateException(String.format(Locale.ROOT, "Mutation group contained no table mutations - %s : `%s`", new Object[]{this.mutationType, this.mutationTarget.getNavigableRole().getFullPath()}));
        }
        if (this.tableMutationBuilderMap.size() == 1) {
            TableMutationBuilder<?> tableMutationBuilder = this.tableMutationBuilderMap.entrySet().iterator().next().getValue();
            Object mutation = tableMutationBuilder.buildMutation();
            if (mutation == null) {
                return new MutationGroupNone(this.mutationType, this.mutationTarget);
            }
            return new MutationGroupSingle(this.mutationType, this.mutationTarget, (TableMutation<?>)mutation);
        }
        ArrayList tableMutations = new ArrayList(this.tableMutationBuilderMap.size());
        this.tableMutationBuilderMap.forEach((name, tableDetailsBuilder) -> {
            Object tableMutation = tableDetailsBuilder.buildMutation();
            if (tableMutation != null) {
                tableMutations.add(tableMutation);
            }
        });
        if (tableMutations.isEmpty()) {
            return new MutationGroupNone(this.mutationType, this.mutationTarget);
        }
        if (tableMutations.size() == 1) {
            return new MutationGroupSingle(this.mutationType, this.mutationTarget, (TableMutation)tableMutations.get(0));
        }
        return new MutationGroupStandard(this.mutationType, this.mutationTarget, tableMutations);
    }

    public String toString() {
        return String.format(Locale.ROOT, "MutationGroupBuilder( %s:`%s` )", this.mutationType.name(), this.mutationTarget.getNavigableRole().getFullPath());
    }
}

