/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.expression;

import jakarta.persistence.criteria.Expression;
import java.util.LinkedHashMap;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.Incubating;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SqmBindableType;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.SqmRenderContext;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.sql.ast.tree.expression.XmlAttributes;

@Incubating
public class SqmXmlAttributesExpression
implements SqmTypedNode<Object> {
    private final Map<String, SqmExpression<?>> attributes;

    public SqmXmlAttributesExpression(String attributeName, Expression<?> expression) {
        LinkedHashMap attributes = new LinkedHashMap();
        attributes.put(attributeName, (SqmExpression)expression);
        this.attributes = attributes;
    }

    private SqmXmlAttributesExpression(Map<String, SqmExpression<?>> attributes) {
        this.attributes = attributes;
    }

    public void attribute(String attributeName, Expression<?> expression) {
        this.attributes.put(attributeName, (SqmExpression)expression);
    }

    public Map<String, SqmExpression<?>> getAttributes() {
        return this.attributes;
    }

    @Override
    public @Nullable SqmBindableType<Object> getNodeType() {
        return null;
    }

    @Override
    public NodeBuilder nodeBuilder() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <X> X accept(SemanticQueryWalker<X> walker) {
        LinkedHashMap<String, org.hibernate.sql.ast.tree.expression.Expression> attributes = new LinkedHashMap<String, org.hibernate.sql.ast.tree.expression.Expression>();
        for (Map.Entry<String, SqmExpression<?>> entry : this.attributes.entrySet()) {
            attributes.put(entry.getKey(), (org.hibernate.sql.ast.tree.expression.Expression)entry.getValue().accept(walker));
        }
        return (X)new XmlAttributes(attributes);
    }

    @Override
    public SqmXmlAttributesExpression copy(SqmCopyContext context) {
        SqmXmlAttributesExpression existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        LinkedHashMap attributes = new LinkedHashMap();
        for (Map.Entry<String, SqmExpression<?>> entry : this.attributes.entrySet()) {
            attributes.put(entry.getKey(), (SqmExpression<?>)entry.getValue().copy(context));
        }
        return context.registerCopy(this, new SqmXmlAttributesExpression(attributes));
    }

    @Override
    public void appendHqlString(StringBuilder hql, SqmRenderContext context) {
        String separator = "xmlattributes(";
        for (Map.Entry<String, SqmExpression<?>> entry : this.attributes.entrySet()) {
            hql.append(separator);
            entry.getValue().appendHqlString(hql, context);
            hql.append(" as ");
            hql.append(entry.getKey());
            separator = ", ";
        }
        hql.append(')');
    }
}

