/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.internal;

import jakarta.persistence.PersistenceException;
import jakarta.persistence.Query;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.TypedQueryReference;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.QueryException;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.query.NamedHqlQueryDefinition;
import org.hibernate.boot.query.NamedNativeQueryDefinition;
import org.hibernate.boot.query.NamedProcedureCallDefinition;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.procedure.spi.NamedCallableQueryMemento;
import org.hibernate.procedure.spi.ProcedureCallImplementor;
import org.hibernate.query.NamedQueryValidationException;
import org.hibernate.query.QueryLogging;
import org.hibernate.query.hql.spi.SqmQueryImplementor;
import org.hibernate.query.named.NamedObjectRepository;
import org.hibernate.query.named.NamedQueryMemento;
import org.hibernate.query.named.NamedResultSetMappingMemento;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.spi.QueryImplementor;
import org.hibernate.query.spi.QueryInterpretationCache;
import org.hibernate.query.sql.spi.NamedNativeQueryMemento;
import org.hibernate.query.sql.spi.NativeQueryImplementor;
import org.hibernate.query.sqm.EntityTypeException;
import org.hibernate.query.sqm.PathElementException;
import org.hibernate.query.sqm.TerminalPathException;
import org.hibernate.query.sqm.UnknownEntityException;
import org.hibernate.query.sqm.UnknownPathException;
import org.hibernate.query.sqm.spi.NamedSqmQueryMemento;
import org.jboss.logging.Logger;

public class NamedObjectRepositoryImpl
implements NamedObjectRepository {
    private static final Logger log = Logger.getLogger(NamedObjectRepository.class);
    private final Map<String, NamedSqmQueryMemento<?>> sqmMementoMap;
    private final Map<String, NamedNativeQueryMemento<?>> sqlMementoMap;
    private final Map<String, NamedCallableQueryMemento> callableMementoMap;
    private final Map<String, NamedResultSetMappingMemento> resultSetMappingMementoMap;

    public NamedObjectRepositoryImpl(Map<String, NamedSqmQueryMemento<?>> sqmMementoMap, Map<String, NamedNativeQueryMemento<?>> sqlMementoMap, Map<String, NamedCallableQueryMemento> callableMementoMap, Map<String, NamedResultSetMappingMemento> resultSetMappingMementoMap) {
        this.sqmMementoMap = sqmMementoMap;
        this.sqlMementoMap = sqlMementoMap;
        this.callableMementoMap = callableMementoMap;
        this.resultSetMappingMementoMap = resultSetMappingMementoMap;
    }

    @Override
    public <R> Map<String, TypedQueryReference<R>> getNamedQueries(Class<R> resultType) {
        HashMap<String, TypedQueryReference<R>> namedQueries = new HashMap<String, TypedQueryReference<R>>(this.sqmMementoMap.size() + this.sqlMementoMap.size());
        for (Map.Entry<String, NamedSqmQueryMemento<?>> entry : this.sqmMementoMap.entrySet()) {
            if (resultType != entry.getValue().getResultType()) continue;
            namedQueries.put(entry.getKey(), (TypedQueryReference)entry.getValue());
        }
        for (Map.Entry<String, NamedQueryMemento<?>> entry : this.sqlMementoMap.entrySet()) {
            if (resultType != ((NamedNativeQueryMemento)entry.getValue()).getResultType()) continue;
            namedQueries.put(entry.getKey(), (TypedQueryReference)entry.getValue());
        }
        return namedQueries;
    }

    @Override
    public void registerNamedQuery(String name, Query query) {
        try {
            ProcedureCallImplementor unwrapped = (ProcedureCallImplementor)query.unwrap(ProcedureCallImplementor.class);
            if (unwrapped != null) {
                this.registerCallableQueryMemento(name, unwrapped.toMemento(name));
                return;
            }
        }
        catch (PersistenceException unwrapped) {
            // empty catch block
        }
        try {
            QueryImplementor queryImplementor = (QueryImplementor)query.unwrap(QueryImplementor.class);
            if (queryImplementor != null) {
                if (queryImplementor instanceof NativeQueryImplementor) {
                    NativeQueryImplementor nativeQueryImplementor = (NativeQueryImplementor)queryImplementor;
                    this.registerNativeQueryMemento(name, (NamedNativeQueryMemento<?>)nativeQueryImplementor.toMemento(name));
                } else if (queryImplementor instanceof SqmQueryImplementor) {
                    SqmQueryImplementor sqmQueryImplementor = (SqmQueryImplementor)queryImplementor;
                    this.registerSqmQueryMemento(name, (NamedSqmQueryMemento<?>)sqmQueryImplementor.toMemento(name));
                } else {
                    throw new AssertionFailure("unknown QueryImplementor");
                }
                return;
            }
        }
        catch (PersistenceException persistenceException) {
            // empty catch block
        }
        throw new PersistenceException("Could not register named query: " + name);
    }

    @Override
    public <R> TypedQueryReference<R> registerNamedQuery(String name, TypedQuery<R> query) {
        if (query instanceof NativeQueryImplementor) {
            NativeQueryImplementor nativeQueryImplementor = (NativeQueryImplementor)query;
            NamedQueryMemento memento = nativeQueryImplementor.toMemento(name);
            this.registerNativeQueryMemento(name, (NamedNativeQueryMemento<?>)memento);
            return memento;
        }
        if (query instanceof SqmQueryImplementor) {
            SqmQueryImplementor sqmQueryImplementor = (SqmQueryImplementor)query;
            NamedQueryMemento memento = sqmQueryImplementor.toMemento(name);
            this.registerSqmQueryMemento(name, (NamedSqmQueryMemento<?>)memento);
            return memento;
        }
        throw new IllegalArgumentException("unknown implementation of TypedQuery");
    }

    @Override
    public NamedSqmQueryMemento<?> getSqmQueryMemento(String queryName) {
        return this.sqmMementoMap.get(queryName);
    }

    @Override
    public void visitSqmQueryMementos(Consumer<NamedSqmQueryMemento<?>> action) {
        this.sqmMementoMap.values().forEach(action);
    }

    @Override
    public void registerSqmQueryMemento(String name, NamedSqmQueryMemento<?> descriptor) {
        this.sqmMementoMap.put(name, descriptor);
        this.sqlMementoMap.remove(name);
    }

    @Override
    public NamedNativeQueryMemento<?> getNativeQueryMemento(String queryName) {
        return this.sqlMementoMap.get(queryName);
    }

    @Override
    public void visitNativeQueryMementos(Consumer<NamedNativeQueryMemento<?>> action) {
        this.sqlMementoMap.values().forEach(action);
    }

    @Override
    public synchronized void registerNativeQueryMemento(String name, NamedNativeQueryMemento<?> descriptor) {
        this.sqlMementoMap.put(name, descriptor);
        this.sqmMementoMap.remove(name);
    }

    @Override
    public NamedCallableQueryMemento getCallableQueryMemento(String name) {
        return this.callableMementoMap.get(name);
    }

    @Override
    public void visitCallableQueryMementos(Consumer<NamedCallableQueryMemento> action) {
        this.callableMementoMap.values().forEach(action);
    }

    @Override
    public synchronized void registerCallableQueryMemento(String name, NamedCallableQueryMemento memento) {
        this.callableMementoMap.put(name, memento);
    }

    @Override
    public NamedResultSetMappingMemento getResultSetMappingMemento(String mappingName) {
        return this.resultSetMappingMementoMap.get(mappingName);
    }

    @Override
    public void visitResultSetMappingMementos(Consumer<NamedResultSetMappingMemento> action) {
        this.resultSetMappingMementoMap.values().forEach(action);
    }

    @Override
    public void registerResultSetMappingMemento(String name, NamedResultSetMappingMemento memento) {
        this.resultSetMappingMementoMap.put(name, memento);
    }

    @Override
    public NamedQueryMemento<?> resolve(SessionFactoryImplementor sessionFactory, MetadataImplementor bootMetamodel, String registrationName) {
        NamedQueryMemento namedQuery = this.sqlMementoMap.get(registrationName);
        if (namedQuery != null) {
            return namedQuery;
        }
        namedQuery = this.sqmMementoMap.get(registrationName);
        if (namedQuery != null) {
            return namedQuery;
        }
        namedQuery = this.callableMementoMap.get(registrationName);
        if (namedQuery != null) {
            return namedQuery;
        }
        NamedHqlQueryDefinition<?> namedHqlQueryDefinition = bootMetamodel.getNamedHqlQueryMapping(registrationName);
        if (namedHqlQueryDefinition != null) {
            NamedQueryMemento resolved = namedHqlQueryDefinition.resolve(sessionFactory);
            this.sqmMementoMap.put(namedHqlQueryDefinition.getRegistrationName(), (NamedSqmQueryMemento<?>)resolved);
            return resolved;
        }
        NamedNativeQueryDefinition<?> namedNativeQueryDefinition = bootMetamodel.getNamedNativeQueryMapping(registrationName);
        if (namedNativeQueryDefinition != null) {
            NamedQueryMemento resolved = namedNativeQueryDefinition.resolve(sessionFactory);
            this.sqlMementoMap.put(namedNativeQueryDefinition.getRegistrationName(), (NamedNativeQueryMemento<?>)resolved);
            return resolved;
        }
        NamedProcedureCallDefinition namedCallableQueryDefinition = bootMetamodel.getNamedProcedureCallMapping(registrationName);
        if (namedCallableQueryDefinition != null) {
            NamedCallableQueryMemento resolved = namedCallableQueryDefinition.resolve(sessionFactory);
            this.callableMementoMap.put(namedCallableQueryDefinition.getRegistrationName(), resolved);
            return resolved;
        }
        return null;
    }

    @Override
    public void prepare(SessionFactoryImplementor sessionFactory, Metadata bootMetamodel) {
        bootMetamodel.visitNamedHqlQueryDefinitions(namedHqlQueryDefinition -> {
            NamedQueryMemento resolved = namedHqlQueryDefinition.resolve(sessionFactory);
            this.sqmMementoMap.put(namedHqlQueryDefinition.getRegistrationName(), (NamedSqmQueryMemento<?>)resolved);
        });
        bootMetamodel.visitNamedNativeQueryDefinitions(namedNativeQueryDefinition -> {
            NamedQueryMemento resolved = namedNativeQueryDefinition.resolve(sessionFactory);
            this.sqlMementoMap.put(namedNativeQueryDefinition.getRegistrationName(), (NamedNativeQueryMemento<?>)resolved);
        });
        bootMetamodel.visitNamedResultSetMappingDefinition(namedResultSetMappingDefinition -> {
            NamedResultSetMappingMemento resolved = namedResultSetMappingDefinition.resolve(() -> sessionFactory);
            this.resultSetMappingMementoMap.put(namedResultSetMappingDefinition.getRegistrationName(), resolved);
        });
        bootMetamodel.visitNamedProcedureCallDefinition(namedProcedureCallDefinition -> {
            NamedCallableQueryMemento resolved = namedProcedureCallDefinition.resolve(sessionFactory);
            this.callableMementoMap.put(namedProcedureCallDefinition.getRegistrationName(), resolved);
        });
    }

    @Override
    public void validateNamedQueries(QueryEngine queryEngine) {
        Map<String, HibernateException> errors = this.checkNamedQueries(queryEngine);
        if (!errors.isEmpty()) {
            int i = 0;
            StringBuilder failingQueries = new StringBuilder("Errors in named queries: ");
            for (Map.Entry<String, HibernateException> entry : errors.entrySet()) {
                QueryLogging.QUERY_MESSAGE_LOGGER.namedQueryError(entry.getKey(), entry.getValue());
                failingQueries.append("\n").append("  [").append(++i).append("] Error in query named '").append(entry.getKey()).append("'").append(": ").append(entry.getValue().getMessage());
            }
            NamedQueryValidationException exception = new NamedQueryValidationException(failingQueries.toString(), errors);
            errors.values().forEach(arg_0 -> exception.addSuppressed(arg_0));
            throw exception;
        }
    }

    @Override
    public Map<String, HibernateException> checkNamedQueries(QueryEngine queryEngine) {
        HashMap<String, HibernateException> errors = new HashMap<String, HibernateException>();
        QueryInterpretationCache interpretationCache = queryEngine.getInterpretationCache();
        log.tracef("Checking %s named HQL queries", this.sqmMementoMap.size());
        for (NamedSqmQueryMemento<?> namedSqmQueryMemento : this.sqmMementoMap.values()) {
            String queryString = namedSqmQueryMemento.getHqlString();
            String registrationName = namedSqmQueryMemento.getRegistrationName();
            try {
                log.tracef("Checking named HQL query: %s", (Object)registrationName);
                interpretationCache.resolveHqlInterpretation(queryString, null, queryEngine.getHqlTranslator());
            }
            catch (QueryException e) {
                errors.put(registrationName, e);
            }
            catch (PathElementException | TerminalPathException e) {
                errors.put(registrationName, new UnknownPathException(e.getMessage(), queryString, e));
            }
            catch (EntityTypeException e) {
                errors.put(registrationName, new UnknownEntityException(e.getMessage(), e.getReference(), e));
            }
        }
        log.tracef("Checking %s named SQL queries", this.sqlMementoMap.size());
        for (NamedNativeQueryMemento namedNativeQueryMemento : this.sqlMementoMap.values()) {
            namedNativeQueryMemento.validate(queryEngine);
        }
        return errors;
    }

    @Override
    public void close() {
        this.sqmMementoMap.clear();
        this.sqlMementoMap.clear();
        this.callableMementoMap.clear();
        this.resultSetMappingMementoMap.clear();
    }
}

