/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.internal;

import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.Bindable;
import jakarta.persistence.metamodel.ManagedType;
import jakarta.persistence.metamodel.Type;
import java.io.Serializable;
import java.lang.reflect.Member;
import org.hibernate.metamodel.AttributeClassification;
import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.model.domain.AnyMappingDomainType;
import org.hibernate.metamodel.model.domain.IdentifiableDomainType;
import org.hibernate.metamodel.model.domain.ManagedDomainType;
import org.hibernate.metamodel.model.domain.PluralPersistentAttribute;
import org.hibernate.metamodel.model.domain.SimpleDomainType;
import org.hibernate.metamodel.model.domain.internal.AbstractAttribute;
import org.hibernate.query.SemanticException;
import org.hibernate.query.criteria.JpaSetReturningFunction;
import org.hibernate.query.hql.spi.SqmCreationState;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SqmBindableType;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.internal.SqmMappingModelHelper;
import org.hibernate.query.sqm.spi.SqmCreationHelper;
import org.hibernate.query.sqm.tree.SqmJoinType;
import org.hibernate.query.sqm.tree.domain.SqmDomainType;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.domain.SqmSingularJoin;
import org.hibernate.query.sqm.tree.domain.SqmSingularPersistentAttribute;
import org.hibernate.query.sqm.tree.expression.SqmSetReturningFunction;
import org.hibernate.query.sqm.tree.from.SqmFrom;
import org.hibernate.query.sqm.tree.from.SqmFunctionJoin;
import org.hibernate.query.sqm.tree.from.SqmJoin;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.spi.EntityIdentifierNavigablePath;
import org.hibernate.spi.NavigablePath;
import org.hibernate.type.BasicPluralType;
import org.hibernate.type.descriptor.java.JavaType;

public class SingularAttributeImpl<D, J>
extends AbstractAttribute<D, J, J>
implements SqmSingularPersistentAttribute<D, J>,
Serializable {
    private final boolean isIdentifier;
    private final boolean isVersion;
    private final boolean isOptional;
    private final SqmPathSource<J> sqmPathSource;

    public SingularAttributeImpl(ManagedDomainType<D> declaringType, String name, AttributeClassification attributeClassification, SqmDomainType<J> attributeType, JavaType<?> relationalJavaType, Member member, boolean isIdentifier, boolean isVersion, boolean isOptional, boolean isGeneric) {
        super(declaringType, name, attributeType.getExpressibleJavaType(), attributeClassification, attributeType, member);
        this.isIdentifier = isIdentifier;
        this.isVersion = isVersion;
        this.isOptional = isOptional;
        this.sqmPathSource = SqmMappingModelHelper.resolveSqmPathSource(name, this, attributeType, relationalJavaType, Bindable.BindableType.SINGULAR_ATTRIBUTE, isGeneric);
    }

    @Override
    public String getPathName() {
        return this.getName();
    }

    @Override
    public JavaType<J> getExpressibleJavaType() {
        return this.sqmPathSource.getExpressibleJavaType();
    }

    @Override
    public SqmDomainType<J> getPathType() {
        return this.sqmPathSource.getPathType();
    }

    @Override
    public SqmDomainType<J> getValueGraphType() {
        return this.getPathType();
    }

    @Override
    public SimpleDomainType<?> getKeyGraphType() {
        Type type;
        Type type2 = this.getType();
        if (type2 instanceof IdentifiableDomainType) {
            IdentifiableDomainType identifiableDomainType = (IdentifiableDomainType)type2;
            type = identifiableDomainType.getIdType();
        } else {
            type = null;
        }
        return type;
    }

    @Override
    public SimpleDomainType<J> getType() {
        return (SimpleDomainType)this.sqmPathSource.getPathType();
    }

    public Class<J> getBindableJavaType() {
        return this.sqmPathSource.getBindableJavaType();
    }

    @Override
    public SqmPathSource<?> findSubPathSource(String name) {
        return this.sqmPathSource.findSubPathSource(name);
    }

    @Override
    public SqmPathSource<?> findSubPathSource(String name, boolean includeSubtypes) {
        return this.sqmPathSource.findSubPathSource(name, includeSubtypes);
    }

    @Override
    public SqmPathSource<J> getSqmPathSource() {
        return this.sqmPathSource;
    }

    @Override
    public SqmBindableType<J> getExpressible() {
        return this.sqmPathSource.getExpressible();
    }

    @Override
    public boolean isGeneric() {
        return this.sqmPathSource.isGeneric();
    }

    @Override
    public SqmJoin<D, J> createSqmJoin(SqmFrom<?, D> lhs, SqmJoinType joinType, String alias, boolean fetched, SqmCreationState creationState) {
        NodeBuilder nodeBuilder = creationState.getCreationContext().getNodeBuilder();
        if (this.getType() instanceof AnyMappingDomainType) {
            throw new SemanticException("An @Any attribute cannot be join fetched");
        }
        if (this.sqmPathSource.getPathType() instanceof BasicPluralType) {
            JpaSetReturningFunction setReturningFunction = nodeBuilder.unnestArray(lhs.get(this.getName()));
            SqmFunctionJoin join = new SqmFunctionJoin(this.createNavigablePath(lhs, alias), setReturningFunction, true, ((SqmSetReturningFunction)setReturningFunction).getType(), alias, joinType, (SqmRoot)lhs);
            return join;
        }
        return new SqmSingularJoin(lhs, this, alias, joinType, fetched, nodeBuilder);
    }

    @Override
    public NavigablePath createNavigablePath(SqmPath<?> parent, String alias) {
        if (parent == null) {
            throw new IllegalArgumentException("LHS cannot be null for a sub-navigable reference - " + this.getName());
        }
        return SqmCreationHelper.buildSubNavigablePath(this.getParentNavigablePath(parent), this.getName(), alias);
    }

    public boolean isId() {
        return this.isIdentifier;
    }

    public boolean isVersion() {
        return this.isVersion;
    }

    public boolean isOptional() {
        return this.isOptional;
    }

    public boolean isAssociation() {
        Attribute.PersistentAttributeType persistentAttributeType = this.getPersistentAttributeType();
        return persistentAttributeType == Attribute.PersistentAttributeType.MANY_TO_ONE || persistentAttributeType == Attribute.PersistentAttributeType.ONE_TO_ONE;
    }

    public boolean isCollection() {
        return false;
    }

    public Bindable.BindableType getBindableType() {
        return Bindable.BindableType.SINGULAR_ATTRIBUTE;
    }

    @Override
    public SqmPath<J> createSqmPath(SqmPath<?> lhs, SqmPathSource<?> intermediatePathSource) {
        return this.sqmPathSource.createSqmPath(lhs, intermediatePathSource);
    }

    @Override
    public JavaType<?> getRelationalJavaType() {
        return this.sqmPathSource.getRelationalJavaType();
    }

    public static class Version<X, Y>
    extends SingularAttributeImpl<X, Y> {
        public Version(ManagedDomainType<X> declaringType, String name, AttributeClassification attributeClassification, SqmDomainType<Y> attributeType, Member member) {
            super(declaringType, name, attributeClassification, attributeType, attributeType.getExpressibleJavaType(), member, false, true, false, false);
        }
    }

    public static class Identifier<D, J>
    extends SingularAttributeImpl<D, J> {
        public Identifier(ManagedDomainType<D> declaringType, String name, SqmDomainType<J> attributeType, Member member, AttributeClassification attributeClassification, boolean isGeneric) {
            super(declaringType, name, attributeClassification, attributeType, attributeType.getExpressibleJavaType(), member, true, false, false, isGeneric);
        }

        @Override
        public NavigablePath createNavigablePath(SqmPath<?> parent, String alias) {
            IdentifiableDomainType declaringType;
            if (parent == null) {
                throw new IllegalArgumentException("LHS cannot be null for a sub-navigable reference - " + this.getName());
            }
            SqmPathSource<?> parentPathSource = parent.getResolvedModel();
            NavigablePath parentNavigablePath = parentPathSource instanceof PluralPersistentAttribute ? parent.getNavigablePath().append(CollectionPart.Nature.ELEMENT.getName()) : parent.getNavigablePath();
            ManagedType managedType = this.getDeclaringType();
            if (managedType instanceof IdentifiableDomainType && !(declaringType = (IdentifiableDomainType)managedType).hasSingleIdAttribute()) {
                return new EntityIdentifierNavigablePath(parentNavigablePath, null).append(this.getName(), SqmCreationHelper.determineAlias(alias));
            }
            return new EntityIdentifierNavigablePath(parentNavigablePath, SqmCreationHelper.determineAlias(alias), this.getName());
        }
    }
}

