/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal;

import jakarta.persistence.EntityGraph;
import jakarta.persistence.PessimisticLockScope;
import jakarta.persistence.Timeout;
import java.util.List;
import org.hibernate.CacheMode;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.NaturalIdMultiLoadAccess;
import org.hibernate.engine.spi.EffectiveEntityGraph;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.graph.GraphSemantic;
import org.hibernate.graph.spi.RootGraphImplementor;
import org.hibernate.internal.NaturalIdHelper;
import org.hibernate.loader.ast.spi.MultiNaturalIdLoadOptions;
import org.hibernate.persister.entity.EntityPersister;

public class NaturalIdMultiLoadAccessStandard<T>
implements NaturalIdMultiLoadAccess<T>,
MultiNaturalIdLoadOptions {
    private final EntityPersister entityDescriptor;
    private final SharedSessionContractImplementor session;
    private LockOptions lockOptions;
    private CacheMode cacheMode;
    private RootGraphImplementor<T> rootGraph;
    private GraphSemantic graphSemantic;
    private Integer batchSize;
    private boolean returnOfDeletedEntitiesEnabled;
    private boolean orderedReturnEnabled = true;

    public NaturalIdMultiLoadAccessStandard(EntityPersister entityDescriptor, SharedSessionContractImplementor session) {
        this.entityDescriptor = entityDescriptor;
        this.session = session;
    }

    @Override
    public NaturalIdMultiLoadAccess<T> with(LockMode lockMode, PessimisticLockScope lockScope) {
        if (this.lockOptions == null) {
            this.lockOptions = new LockOptions();
        }
        this.lockOptions.setLockMode(lockMode);
        this.lockOptions.setLockScope(lockScope);
        return this;
    }

    @Override
    public NaturalIdMultiLoadAccess<T> with(Timeout timeout) {
        if (this.lockOptions == null) {
            this.lockOptions = new LockOptions();
        }
        this.lockOptions.setTimeOut(timeout.milliseconds());
        return this;
    }

    @Override
    public NaturalIdMultiLoadAccess<T> with(LockOptions lockOptions) {
        this.lockOptions = lockOptions;
        return this;
    }

    @Override
    public NaturalIdMultiLoadAccess<T> with(CacheMode cacheMode) {
        this.cacheMode = cacheMode;
        return this;
    }

    @Override
    public NaturalIdMultiLoadAccess<T> with(EntityGraph<T> graph, GraphSemantic semantic) {
        this.rootGraph = (RootGraphImplementor)graph;
        this.graphSemantic = semantic;
        return this;
    }

    @Override
    public NaturalIdMultiLoadAccess<T> withBatchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    @Override
    public NaturalIdMultiLoadAccess<T> enableReturnOfDeletedEntities(boolean enabled) {
        this.returnOfDeletedEntitiesEnabled = enabled;
        return this;
    }

    @Override
    public NaturalIdMultiLoadAccess<T> enableOrderedReturn(boolean enabled) {
        this.orderedReturnEnabled = enabled;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<T> multiLoad(Object ... ids) {
        NaturalIdHelper.performAnyNeededCrossReferenceSynchronizations(true, this.entityDescriptor, this.session);
        CacheMode sessionCacheMode = this.session.getCacheMode();
        boolean cacheModeChanged = false;
        if (this.cacheMode != null && this.cacheMode != sessionCacheMode) {
            this.session.setCacheMode(this.cacheMode);
            cacheModeChanged = true;
        }
        LoadQueryInfluencers loadQueryInfluencers = this.session.getLoadQueryInfluencers();
        try {
            boolean hadInitialGraph;
            EffectiveEntityGraph effectiveEntityGraph = loadQueryInfluencers.getEffectiveEntityGraph();
            GraphSemantic initialGraphSemantic = effectiveEntityGraph.getSemantic();
            RootGraphImplementor<?> initialGraph = effectiveEntityGraph.getGraph();
            boolean bl = hadInitialGraph = initialGraphSemantic != null;
            if (this.graphSemantic != null) {
                if (this.rootGraph == null) {
                    throw new IllegalArgumentException("Graph semantic specified, but no RootGraph was supplied");
                }
                effectiveEntityGraph.applyGraph(this.rootGraph, this.graphSemantic);
            }
            try {
                List<?> list = this.entityDescriptor.getMultiNaturalIdLoader().multiLoad(ids, this, this.session);
                if (this.graphSemantic != null) {
                    if (hadInitialGraph) {
                        effectiveEntityGraph.applyGraph(initialGraph, initialGraphSemantic);
                    } else {
                        effectiveEntityGraph.clear();
                    }
                }
                return list;
            }
            catch (Throwable throwable) {
                if (this.graphSemantic != null) {
                    if (hadInitialGraph) {
                        effectiveEntityGraph.applyGraph(initialGraph, initialGraphSemantic);
                    } else {
                        effectiveEntityGraph.clear();
                    }
                }
                throw throwable;
            }
        }
        finally {
            if (cacheModeChanged) {
                this.session.setCacheMode(sessionCacheMode);
            }
        }
    }

    @Override
    public List<T> multiLoad(List<?> ids) {
        return this.multiLoad(ids.toArray(new Object[0]));
    }

    @Override
    public boolean isReturnOfDeletedEntitiesEnabled() {
        return this.returnOfDeletedEntitiesEnabled;
    }

    @Override
    public boolean isOrderReturnEnabled() {
        return this.orderedReturnEnabled;
    }

    @Override
    public LockOptions getLockOptions() {
        return this.lockOptions;
    }

    @Override
    public Integer getBatchSize() {
        return this.batchSize;
    }
}

