/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal;

import org.hibernate.HibernateException;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.AbstractScrollableResults;
import org.hibernate.sql.results.internal.RowProcessingStateStandardImpl;
import org.hibernate.sql.results.jdbc.internal.JdbcValuesSourceProcessingStateStandardImpl;
import org.hibernate.sql.results.jdbc.spi.JdbcValues;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesSourceProcessingOptions;
import org.hibernate.sql.results.spi.LoadContexts;
import org.hibernate.sql.results.spi.RowReader;

public class FetchingScrollableResultsImpl<R>
extends AbstractScrollableResults<R> {
    private R currentRow;
    private int currentPosition;
    private Integer maxPosition;
    private boolean beforeFirst;
    private boolean afterLast;

    public FetchingScrollableResultsImpl(JdbcValues jdbcValues, JdbcValuesSourceProcessingOptions processingOptions, JdbcValuesSourceProcessingStateStandardImpl jdbcValuesSourceProcessingState, RowProcessingStateStandardImpl rowProcessingState, RowReader<R> rowReader, SharedSessionContractImplementor persistenceContext) {
        super(jdbcValues, processingOptions, jdbcValuesSourceProcessingState, rowProcessingState, rowReader, persistenceContext);
        this.maxPosition = jdbcValuesSourceProcessingState.getQueryOptions().getEffectiveLimit().getMaxRows();
        this.beforeFirst = true;
    }

    @Override
    protected R getCurrentRow() {
        return this.currentRow;
    }

    @Override
    public boolean next() {
        if (this.afterLast || this.isResultSetEmpty()) {
            return false;
        }
        if (this.maxPosition != null && this.maxPosition <= this.currentPosition) {
            this.currentPosition = this.maxPosition + 1;
            this.currentRow = null;
            this.afterLast = true;
            this.beforeFirst = false;
            return false;
        }
        if (this.beforeFirst && !this.getRowProcessingState().next()) {
            this.currentPosition = 0;
            this.beforeFirst = false;
            return false;
        }
        boolean last = this.prepareCurrentRow();
        this.beforeFirst = false;
        ++this.currentPosition;
        if (last && this.maxPosition == null) {
            this.maxPosition = this.currentPosition;
        }
        this.afterScrollOperation();
        return true;
    }

    @Override
    public boolean previous() {
        EntityKey checkKey;
        if (this.beforeFirst || this.isResultSetEmpty()) {
            return false;
        }
        if (this.currentPosition == 1) {
            this.beforeFirst();
            return false;
        }
        EntityKey keyToRead = null;
        if (this.afterLast) {
            this.getRowProcessingState().last();
            keyToRead = this.getEntityKey();
        } else {
            this.getRowProcessingState().previous();
            boolean firstPass = true;
            EntityKey lastKey = this.getEntityKey();
            while (this.getRowProcessingState().previous()) {
                EntityKey checkKey2 = this.getEntityKey();
                if (firstPass) {
                    firstPass = false;
                    keyToRead = checkKey2;
                }
                if (lastKey.equals(checkKey2)) continue;
            }
        }
        while (this.getRowProcessingState().previous() && keyToRead.equals(checkKey = this.getEntityKey())) {
        }
        this.getRowProcessingState().next();
        this.prepareCurrentRow();
        this.afterLast = false;
        --this.currentPosition;
        this.afterScrollOperation();
        return true;
    }

    @Override
    public boolean scroll(int positions) {
        boolean more = false;
        if (positions > 0) {
            for (int i = 0; i < positions && (more = this.next()); ++i) {
            }
        } else if (positions < 0) {
            for (int i = 0; i < -positions && (more = this.previous()); ++i) {
            }
        } else {
            throw new HibernateException("scroll(0) not valid");
        }
        this.afterScrollOperation();
        return more;
    }

    @Override
    public boolean position(int position) {
        return this.setRowNumber(position);
    }

    @Override
    public boolean last() {
        boolean more = false;
        if (this.maxPosition != null) {
            if (this.currentPosition > this.maxPosition) {
                more = this.previous();
            }
            for (int i = this.currentPosition; i < this.maxPosition; ++i) {
                more = this.next();
            }
        } else {
            if (this.isResultSetEmpty() || this.afterLast) {
                return false;
            }
            while (!this.afterLast) {
                more = this.next();
            }
        }
        this.afterScrollOperation();
        return more;
    }

    @Override
    public boolean first() {
        this.beforeFirst();
        boolean more = this.next();
        return more;
    }

    @Override
    public void beforeFirst() {
        this.getRowProcessingState().beforeFirst();
        this.beforeFirst = true;
        this.afterLast = false;
        this.currentRow = null;
        this.currentPosition = 0;
    }

    @Override
    public void afterLast() {
        this.last();
        this.next();
        this.afterScrollOperation();
    }

    @Override
    public boolean isFirst() {
        return this.currentPosition == 1;
    }

    @Override
    public boolean isLast() {
        return this.maxPosition != null && this.currentPosition == this.maxPosition;
    }

    @Override
    public int getRowNumber() {
        return this.currentPosition - 1;
    }

    @Override
    public int getPosition() {
        return this.currentPosition;
    }

    @Override
    public boolean setRowNumber(int rowNumber) {
        if (rowNumber == 1) {
            return this.first();
        }
        if (rowNumber == -1 || this.maxPosition != null && rowNumber == this.maxPosition) {
            return this.last();
        }
        if (rowNumber < 0 && this.maxPosition == null) {
            while (this.next()) {
            }
            return this.scroll(rowNumber);
        }
        int targetRowNumber = rowNumber < 0 ? this.maxPosition + rowNumber + 1 : rowNumber;
        return this.scroll(targetRowNumber - this.currentPosition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean prepareCurrentRow() {
        RowProcessingStateStandardImpl rowProcessingState = this.getRowProcessingState();
        RowReader rowReader = this.getRowReader();
        boolean last = false;
        boolean resultProcessed = false;
        EntityKey entityKey = this.getEntityKey();
        PersistenceContext persistenceContext = rowProcessingState.getSession().getPersistenceContext();
        LoadContexts loadContexts = persistenceContext.getLoadContexts();
        loadContexts.register(this.getJdbcValuesSourceProcessingState());
        persistenceContext.beforeLoad();
        try {
            this.currentRow = rowReader.readRow(rowProcessingState);
            rowProcessingState.finishRowProcessing(true);
            while (!resultProcessed) {
                if (rowProcessingState.next()) {
                    EntityKey entityKey2 = this.getEntityKey();
                    if (!entityKey.equals(entityKey2)) {
                        resultProcessed = true;
                        last = false;
                        continue;
                    }
                    rowReader.readRow(rowProcessingState);
                    rowProcessingState.finishRowProcessing(false);
                    continue;
                }
                last = true;
                resultProcessed = true;
            }
            this.getJdbcValuesSourceProcessingState().finishUp(false);
        }
        finally {
            persistenceContext.afterLoad();
            loadContexts.deregister(this.getJdbcValuesSourceProcessingState());
        }
        persistenceContext.initializeNonLazyCollections();
        this.afterScrollOperation();
        return last;
    }

    private boolean isResultSetEmpty() {
        return this.currentPosition == 0 && !this.beforeFirst && !this.afterLast;
    }

    private EntityKey getEntityKey() {
        return this.getRowReader().resolveSingleResultEntityKey(this.getRowProcessingState());
    }
}

