/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.profile;

import java.util.HashMap;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.Internal;
import org.hibernate.engine.FetchStyle;
import org.hibernate.engine.profile.Association;
import org.hibernate.engine.profile.Fetch;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.type.BagType;
import org.hibernate.type.CollectionType;
import org.hibernate.type.Type;

public class FetchProfile {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(FetchProfile.class);
    private final String name;
    private final Map<String, Fetch> fetches = new HashMap<String, Fetch>();
    private boolean containsJoinFetchedCollection;
    private boolean containsJoinFetchedBag;
    private @Nullable Fetch bagJoinFetch;

    public FetchProfile(String name) {
        this.name = name;
    }

    @Internal
    public void addFetch(Fetch fetch) {
        Association association = fetch.getAssociation();
        String role = association.getRole();
        Type associationType = association.getOwner().getPropertyType(association.getAssociationPath());
        if (associationType instanceof CollectionType) {
            LOG.tracev("Handling request to add collection fetch [{0}]", role);
            if (fetch.getMethod() == FetchStyle.JOIN) {
                if (associationType instanceof BagType && this.containsJoinFetchedCollection) {
                    LOG.containsJoinFetchedCollection(role);
                    return;
                }
                if (this.containsJoinFetchedBag) {
                    if (this.bagJoinFetch != null && this.fetches.remove(this.bagJoinFetch.getAssociation().getRole()) != this.bagJoinFetch) {
                        LOG.unableToRemoveBagJoinFetch();
                    }
                    this.bagJoinFetch = null;
                    this.containsJoinFetchedBag = false;
                }
                this.containsJoinFetchedCollection = true;
            }
        }
        this.fetches.put(role, fetch);
    }

    public String getName() {
        return this.name;
    }

    public Map<String, Fetch> getFetches() {
        return this.fetches;
    }

    public @Nullable Fetch getFetchByRole(String role) {
        return this.fetches.get(role);
    }

    public String toString() {
        return "FetchProfile[" + this.name + "]";
    }

    public boolean hasSubselectLoadableCollectionsEnabled(EntityPersister persister) {
        for (Fetch fetch : this.getFetches().values()) {
            if (fetch.getMethod() != FetchStyle.SUBSELECT || fetch.getAssociation().getOwner() != persister) continue;
            return true;
        }
        return false;
    }
}

