/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc.proxy;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;
import org.hibernate.HibernateException;
import org.hibernate.Internal;
import org.hibernate.engine.jdbc.CharacterStream;
import org.hibernate.engine.jdbc.ClobImplementer;
import org.hibernate.engine.jdbc.internal.CharacterStreamImpl;
import org.hibernate.internal.util.ReaderInputStream;
import org.hibernate.type.descriptor.java.DataHelper;

@Internal
public class ClobProxy
implements Clob,
ClobImplementer {
    private final CharacterStream characterStream;
    private boolean needsReset;

    protected ClobProxy(String string) {
        this.characterStream = new CharacterStreamImpl(string);
    }

    protected ClobProxy(Reader reader, long length) {
        this.characterStream = new CharacterStreamImpl(reader, length);
    }

    @Override
    public long length() {
        return this.characterStream.getLength();
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        return new ReaderInputStream(this.getCharacterStream());
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        return this.getUnderlyingStream().asReader();
    }

    @Override
    public CharacterStream getUnderlyingStream() {
        this.resetIfNeeded();
        return this.characterStream;
    }

    @Override
    public long position(String searchstr, long start) throws SQLException {
        return this.characterStream.asString().indexOf(searchstr, (int)start + 1);
    }

    @Override
    public long position(Clob searchstr, long start) throws SQLException {
        throw ClobProxy.notSupported();
    }

    @Override
    public int setString(long pos, String str) throws SQLException {
        throw ClobProxy.notSupported();
    }

    @Override
    public int setString(long pos, String str, int offset, int len) throws SQLException {
        throw ClobProxy.notSupported();
    }

    @Override
    public OutputStream setAsciiStream(long pos) {
        throw ClobProxy.notSupported();
    }

    @Override
    public Writer setCharacterStream(long pos) {
        throw ClobProxy.notSupported();
    }

    @Override
    public void truncate(long len) throws SQLException {
        throw ClobProxy.notSupported();
    }

    @Override
    public String getSubString(long start, int length) throws SQLException {
        if (start < 1L) {
            throw new SQLException("Start position 1-based; must be 1 or more.");
        }
        if (start > this.length() + 1L) {
            throw new SQLException("Start position [" + start + "] cannot exceed overall CLOB length [" + this.length() + "]");
        }
        if (length < 0) {
            throw new SQLException("Length must be great-than-or-equal to zero.");
        }
        String string = this.characterStream.asString();
        long endIndex = Math.min(start + (long)length - 1L, (long)string.length());
        return string.substring((int)start - 1, (int)endIndex);
    }

    @Override
    public Reader getCharacterStream(long start, long length) throws SQLException {
        if (start < 1L) {
            throw new SQLException("Start position 1-based; must be 1 or more.");
        }
        if (start > this.length() + 1L) {
            throw new SQLException("Start position [" + start + "] cannot exceed overall CLOB length [" + this.length() + "]");
        }
        if (length > Integer.MAX_VALUE) {
            throw new SQLException("Can't deal with Clobs larger than 'Integer.MAX_VALUE'");
        }
        if (length < 0L) {
            throw new SQLException("Length must be greater than or equal to zero");
        }
        return DataHelper.subStream(this.getCharacterStream(), start - 1L, (int)length);
    }

    @Override
    public void free() throws SQLException {
        this.characterStream.release();
    }

    protected void resetIfNeeded() {
        try {
            if (this.needsReset) {
                this.characterStream.asReader().reset();
            }
        }
        catch (IOException ioe) {
            throw new HibernateException("could not reset reader", ioe);
        }
        this.needsReset = true;
    }

    public static Clob generateProxy(String string) {
        return new ClobProxy(string);
    }

    public static Clob generateProxy(Reader reader, long length) {
        return new ClobProxy(reader, length);
    }

    private static UnsupportedOperationException notSupported() {
        return new UnsupportedOperationException("Clob may not be manipulated from creating session");
    }
}

