/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.internal;

import java.lang.invoke.MethodHandles;
import org.hibernate.Internal;
import org.hibernate.internal.log.SubSystemLogging;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.ValidIdRange;

@SubSystemLogging(name="org.hibernate.orm.mapping.natural_id", description="Logging related to handling of natural id mappings")
@Internal
@MessageLogger(projectCode="HHH")
@ValidIdRange(min=90001, max=90100)
public interface NaturalIdLogging
extends BasicLogger {
    public static final String LOGGER_NAME = "org.hibernate.orm.mapping.natural_id";
    public static final Logger NATURAL_ID_LOGGER = Logger.getLogger((String)"org.hibernate.orm.mapping.natural_id");
    public static final NaturalIdLogging NATURAL_ID_MESSAGE_LOGGER = (NaturalIdLogging)Logger.getMessageLogger((MethodHandles.Lookup)MethodHandles.lookup(), NaturalIdLogging.class, (String)"org.hibernate.orm.mapping.natural_id");

    @LogMessage(level=Logger.Level.TRACE)
    @Message(value="Caching natural id resolution from load [%s] : %s -> %s", id=90001)
    public void cachingNaturalIdResolutionFromLoad(String var1, Object var2, Object var3);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(value="Locally caching natural id resolution [%s] : %s -> %s", id=90002)
    public void locallyCachingNaturalIdResolution(String var1, Object var2, Object var3);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(value="Removing locally cached natural id resolution [%s] : %s -> %s", id=90003)
    public void removingLocallyCachedNaturalIdResolution(String var1, Object var2, Object var3);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(value="Resolved natural key [%s] -> primary key [%s] resolution in session cache for [%s]", id=90004)
    public void resolvedNaturalIdInSessionCache(Object var1, Object var2, String var3);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(value="Found natural key [%s] -> primary key [%s] xref in second-level cache for [%s]", id=90005)
    public void foundNaturalIdInSecondLevelCache(Object var1, Object var2, String var3);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(value="Retrieving primary key of %s from database for natural id: %s", id=90006)
    public void retrievingIdForNaturalId(String var1, Object var2);
}

