/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.lock.internal;

import jakarta.persistence.Timeout;
import org.hibernate.dialect.RowLockStrategy;
import org.hibernate.dialect.lock.PessimisticLockStyle;
import org.hibernate.dialect.lock.spi.ConnectionLockTimeoutStrategy;
import org.hibernate.dialect.lock.spi.LockTimeoutType;
import org.hibernate.dialect.lock.spi.LockingSupport;
import org.hibernate.dialect.lock.spi.OuterJoinLockingType;

public class LockingSupportParameterized
implements LockingSupport,
LockingSupport.Metadata {
    private final PessimisticLockStyle pessimisticLockStyle;
    private final RowLockStrategy rowLockStrategy;
    private final LockTimeoutType supportsWaitType;
    private final LockTimeoutType supportsNoWaitType;
    private final LockTimeoutType supportsSkipLockedType;
    private final OuterJoinLockingType outerJoinLockingType;

    public LockingSupportParameterized(PessimisticLockStyle pessimisticLockStyle, RowLockStrategy rowLockStrategy, LockTimeoutType waitType, LockTimeoutType noWaitType, LockTimeoutType skipLockedType, OuterJoinLockingType outerJoinLockingType) {
        this.pessimisticLockStyle = pessimisticLockStyle;
        this.rowLockStrategy = rowLockStrategy;
        this.supportsWaitType = waitType;
        this.supportsNoWaitType = noWaitType;
        this.supportsSkipLockedType = skipLockedType;
        this.outerJoinLockingType = outerJoinLockingType;
    }

    public LockingSupportParameterized(PessimisticLockStyle pessimisticLockStyle, RowLockStrategy rowLockStrategy, boolean supportsWait, boolean supportsNoWait, boolean supportsSkipLocked, OuterJoinLockingType outerJoinLockingType) {
        this(pessimisticLockStyle, rowLockStrategy, supportsWait ? LockTimeoutType.QUERY : LockTimeoutType.NONE, supportsNoWait ? LockTimeoutType.QUERY : LockTimeoutType.NONE, supportsSkipLocked ? LockTimeoutType.QUERY : LockTimeoutType.NONE, outerJoinLockingType);
    }

    @Override
    public LockingSupport.Metadata getMetadata() {
        return this;
    }

    @Override
    public PessimisticLockStyle getPessimisticLockStyle() {
        return this.pessimisticLockStyle;
    }

    @Override
    public RowLockStrategy getWriteRowLockStrategy() {
        return this.rowLockStrategy;
    }

    @Override
    public LockTimeoutType getLockTimeoutType(Timeout timeout) {
        return switch (timeout.milliseconds()) {
            case -2 -> this.supportsSkipLockedType;
            case 0 -> this.supportsNoWaitType;
            case -1 -> LockTimeoutType.QUERY;
            default -> this.supportsWaitType;
        };
    }

    @Override
    public OuterJoinLockingType getOuterJoinLockingType() {
        return this.outerJoinLockingType;
    }

    @Override
    public ConnectionLockTimeoutStrategy getConnectionLockTimeoutStrategy() {
        return ConnectionLockTimeoutStrategy.NONE;
    }
}

