/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function.array;

import java.util.List;
import org.hibernate.dialect.function.array.ArrayArgumentValidator;
import org.hibernate.query.sqm.SqmBindableType;
import org.hibernate.query.sqm.produce.function.ArgumentsValidator;
import org.hibernate.query.sqm.produce.function.FunctionArgumentException;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.query.sqm.tree.domain.SqmDomainType;
import org.hibernate.type.BasicType;
import org.hibernate.type.BindingContext;

public class ArrayAndElementArgumentValidator
extends ArrayArgumentValidator {
    public static final ArgumentsValidator DEFAULT_INSTANCE = new ArrayAndElementArgumentValidator(0, 1);
    private final int[] elementIndexes;

    public ArrayAndElementArgumentValidator(int arrayIndex, int ... elementIndexes) {
        super(arrayIndex);
        this.elementIndexes = elementIndexes;
    }

    @Override
    public void validate(List<? extends SqmTypedNode<?>> arguments, String functionName, BindingContext bindingContext) {
        BasicType<?> expectedElementType = this.getElementType(arguments, functionName, bindingContext);
        for (int elementIndex : this.elementIndexes) {
            SqmDomainType elementType;
            if (elementIndex >= arguments.size()) continue;
            SqmTypedNode<?> elementArgument = arguments.get(elementIndex);
            SqmBindableType<?> expressible = elementArgument.getExpressible();
            SqmDomainType sqmDomainType = elementType = expressible != null ? expressible.getSqmType() : null;
            if (expectedElementType == null || elementType == null || expectedElementType == elementType) continue;
            throw new FunctionArgumentException(String.format("Parameter %d of function '%s()' has type %s, but argument is of type '%s'", elementIndex, functionName, expectedElementType.getJavaTypeDescriptor().getTypeName(), elementType.getTypeName()));
        }
    }
}

