/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function;

import java.time.Duration;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.dialect.function.NumberSeriesGenerateSeriesFunction;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.NullnessHelper;
import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.JdbcMappingContainer;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.sqm.function.SelfRenderingSqmSetReturningFunction;
import org.hibernate.query.sqm.produce.function.SetReturningFunctionTypeResolver;
import org.hibernate.query.sqm.sql.SqmToSqlAstConverter;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.query.sqm.tuple.internal.AnonymousTupleTableGroupProducer;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.AbstractSqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.Literal;
import org.hibernate.sql.ast.tree.from.FunctionTableGroup;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.type.spi.TypeConfiguration;

public class H2GenerateSeriesFunction
extends NumberSeriesGenerateSeriesFunction {
    public H2GenerateSeriesFunction(int maxSeriesSize, TypeConfiguration typeConfiguration) {
        super((SetReturningFunctionTypeResolver)new H2GenerateSeriesSetReturningFunctionTypeResolver(), typeConfiguration.getBasicTypeRegistry().resolve(Duration.class, 3100), maxSeriesSize);
    }

    @Override
    public boolean rendersIdentifierVariable(List<SqlAstNode> arguments, SessionFactoryImplementor sessionFactory) {
        return true;
    }

    @Override
    protected <T> SelfRenderingSqmSetReturningFunction<T> generateSqmSetReturningFunctionExpression(List<? extends SqmTypedNode<?>> arguments, QueryEngine queryEngine) {
        return new SelfRenderingSqmSetReturningFunction<T>(this, this, arguments, this.getArgumentsValidator(), this.getSetReturningTypeResolver(), queryEngine.getCriteriaBuilder(), this.getName()){

            @Override
            public TableGroup convertToSqlAst(NavigablePath navigablePath, String identifierVariable, boolean lateral, boolean canUseInnerJoins, boolean withOrdinality, SqmToSqlAstConverter walker) {
                FunctionTableGroup functionTableGroup = (FunctionTableGroup)super.convertToSqlAst(navigablePath, identifierVariable, lateral, canUseInnerJoins, withOrdinality, walker);
                List<? extends SqlAstNode> sqlArguments = functionTableGroup.getPrimaryTableReference().getFunctionExpression().getArguments();
                Expression startExpression = (Expression)sqlArguments.get(0);
                Expression stopExpression = (Expression)sqlArguments.get(1);
                Expression explicitStepExpression = sqlArguments.size() > 2 ? (Expression)sqlArguments.get(2) : null;
                boolean needsEmulation = H2GenerateSeriesFunction.needsEmulation(startExpression) || H2GenerateSeriesFunction.needsEmulation(stopExpression) || explicitStepExpression != null && H2GenerateSeriesFunction.needsEmulation(explicitStepExpression);
                ModelPart elementPart = functionTableGroup.getModelPart().findSubPart(CollectionPart.Nature.ELEMENT.getName(), null);
                boolean isTemporal = elementPart.getSingleJdbcMapping().getJdbcType().isTemporal();
                if (needsEmulation || withOrdinality || isTemporal) {
                    walker.registerQueryTransformer(new NumberSeriesGenerateSeriesFunction.NumberSeriesQueryTransformer(functionTableGroup, functionTableGroup, "x", H2GenerateSeriesFunction.this.coerceToTimestamp));
                }
                return functionTableGroup;
            }
        };
    }

    @Override
    protected void renderGenerateSeries(SqlAppender sqlAppender, Expression start, Expression stop, @Nullable Expression step, AnonymousTupleTableGroupProducer tupleType, String tableIdentifierVariable, SqlAstTranslator<?> walker) {
        boolean needsEmulation = H2GenerateSeriesFunction.needsEmulation(start) || H2GenerateSeriesFunction.needsEmulation(stop) || step != null && H2GenerateSeriesFunction.needsEmulation(step);
        ModelPart elementPart = tupleType.findSubPart(CollectionPart.Nature.ELEMENT.getName(), null);
        ModelPart ordinalityPart = tupleType.findSubPart(CollectionPart.Nature.INDEX.getName(), null);
        boolean isTemporal = elementPart.getSingleJdbcMapping().getJdbcType().isTemporal();
        if (needsEmulation || ordinalityPart != null || isTemporal) {
            boolean stepNeedsVariable;
            boolean startNeedsVariable = H2GenerateSeriesFunction.needsVariable(start);
            boolean bl = stepNeedsVariable = step != null && H2GenerateSeriesFunction.needsVariable(step);
            if (startNeedsVariable || stepNeedsVariable) {
                sqlAppender.appendSql("((values ");
                int separator = 40;
                if (startNeedsVariable) {
                    sqlAppender.appendSql((char)separator);
                    start.accept(walker);
                    separator = 44;
                }
                if (stepNeedsVariable) {
                    sqlAppender.appendSql((char)separator);
                    step.accept(walker);
                }
                sqlAppender.appendSql(")) ");
                sqlAppender.appendSql(tableIdentifierVariable);
                sqlAppender.appendSql("_");
                separator = 40;
                if (startNeedsVariable) {
                    sqlAppender.appendSql((char)separator);
                    sqlAppender.appendSql("b");
                    separator = 44;
                }
                if (stepNeedsVariable) {
                    sqlAppender.appendSql((char)separator);
                    sqlAppender.appendSql("s");
                }
                sqlAppender.appendSql(") join ");
            }
            sqlAppender.appendSql("system_range(1,");
            sqlAppender.appendSql(this.maxSeriesSize);
            sqlAppender.appendSql(") ");
            sqlAppender.appendSql(tableIdentifierVariable);
            if (startNeedsVariable || stepNeedsVariable) {
                sqlAppender.appendSql(" on true)");
            }
        } else {
            sqlAppender.appendSql("system_range(");
            start.accept(walker);
            sqlAppender.appendSql(',');
            stop.accept(walker);
            if (step != null) {
                sqlAppender.appendSql(',');
                step.accept(walker);
            }
            sqlAppender.appendSql(") ");
            sqlAppender.appendSql(tableIdentifierVariable);
        }
    }

    private static boolean needsEmulation(Expression expression) {
        return !(expression instanceof Literal) && !AbstractSqlAstTranslator.isParameter(expression);
    }

    private static class H2GenerateSeriesSetReturningFunctionTypeResolver
    extends NumberSeriesGenerateSeriesFunction.NumberSeriesGenerateSeriesSetReturningFunctionTypeResolver {
        public H2GenerateSeriesSetReturningFunctionTypeResolver() {
            super("x", "x");
        }

        @Override
        public SelectableMapping[] resolveFunctionReturnType(List<? extends SqlAstNode> arguments, String tableIdentifierVariable, boolean lateral, boolean withOrdinality, SqmToSqlAstConverter converter) {
            Expression start = (Expression)arguments.get(0);
            Expression stop = (Expression)arguments.get(1);
            JdbcMappingContainer expressionType = NullnessHelper.coalesce(start.getExpressionType(), stop.getExpressionType());
            Expression explicitStep = arguments.size() > 2 ? (Expression)arguments.get(2) : null;
            ColumnReference joinBaseColumnReference = NullnessHelper.coalesce(start.getColumnReference(), stop.getColumnReference(), explicitStep != null ? explicitStep.getColumnReference() : null);
            JdbcMapping type = expressionType.getSingleJdbcMapping();
            if (type == null) {
                throw new IllegalArgumentException("Couldn't determine types of arguments to function 'generate_series'");
            }
            if (joinBaseColumnReference != null || withOrdinality || type.getJdbcType().isTemporal()) {
                return this.resolveIterationVariableBasedFunctionReturnType(arguments, tableIdentifierVariable, lateral, withOrdinality, converter);
            }
            return super.resolveFunctionReturnType(arguments, tableIdentifierVariable, lateral, withOrdinality, converter);
        }
    }
}

