/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.aggregate;

import java.util.LinkedHashMap;
import java.util.Map;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.aggregate.AggregateSupport;
import org.hibernate.dialect.aggregate.AggregateSupportImpl;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.Column;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.metamodel.mapping.SelectablePath;
import org.hibernate.metamodel.mapping.SqlTypedMapping;
import org.hibernate.sql.ast.SqlAstNodeRenderingMode;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.type.BasicPluralType;
import org.hibernate.type.descriptor.jdbc.AggregateJdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.spi.TypeConfiguration;

public class PostgreSQLAggregateSupport
extends AggregateSupportImpl {
    private static final AggregateSupport INSTANCE = new PostgreSQLAggregateSupport();
    private static final String XML_EXTRACT_START = "xmlelement(name \"e\",(select xmlagg(t.v) from xmltable(";
    private static final String XML_EXTRACT_SEPARATOR = "/*' passing ";
    private static final String XML_EXTRACT_END = " columns v xml path '.')t))";
    private static final String XML_QUERY_START = "(select xmlagg(t.v) from xmltable(";
    private static final String XML_QUERY_SEPARATOR = "' passing ";
    private static final String XML_QUERY_END = " columns v xml path '.')t)";

    public static AggregateSupport valueOf(Dialect dialect) {
        return INSTANCE;
    }

    @Override
    public String aggregateComponentCustomReadExpression(String template, String placeholder, String aggregateParentReadExpression, String columnExpression, int aggregateColumnTypeCode, SqlTypedMapping column, TypeConfiguration typeConfiguration) {
        switch (aggregateColumnTypeCode) {
            case 3001: 
            case 3018: {
                switch (column.getJdbcMapping().getJdbcType().getDefaultSqlTypeCode()) {
                    case 3001: 
                    case 3018: {
                        return template.replace(placeholder, aggregateParentReadExpression + "->'" + columnExpression + "'");
                    }
                    case -3: 
                    case -2: 
                    case 4003: {
                        return template.replace(placeholder, "decode(" + aggregateParentReadExpression + "->>'" + columnExpression + "','hex')");
                    }
                    case 2003: {
                        BasicPluralType pluralType = (BasicPluralType)column.getJdbcMapping();
                        switch (pluralType.getElementType().getJdbcType().getDefaultSqlTypeCode()) {
                            case -6: 
                            case -5: 
                            case 4: 
                            case 5: 
                            case 6: 
                            case 8: 
                            case 16: {
                                return template.replace(placeholder, "cast(array(select jsonb_array_elements(" + aggregateParentReadExpression + "->'" + columnExpression + "')) as " + column.getColumnDefinition() + ")");
                            }
                            case -3: 
                            case -2: 
                            case 4003: {
                                return template.replace(placeholder, "array(select decode(jsonb_array_elements_text(" + aggregateParentReadExpression + "->'" + columnExpression + "'),'hex'))");
                            }
                        }
                        return template.replace(placeholder, "cast(array(select jsonb_array_elements_text(" + aggregateParentReadExpression + "->'" + columnExpression + "')) as " + column.getColumnDefinition() + ")");
                    }
                }
                return template.replace(placeholder, "cast(" + aggregateParentReadExpression + "->>'" + columnExpression + "' as " + column.getColumnDefinition() + ")");
            }
            case 2009: 
            case 3019: {
                switch (column.getJdbcMapping().getJdbcType().getDefaultSqlTypeCode()) {
                    case 2009: {
                        return template.replace(placeholder, XML_EXTRACT_START + PostgreSQLAggregateSupport.xmlExtractArguments(aggregateParentReadExpression, columnExpression + "/*") + XML_EXTRACT_END);
                    }
                    case 3019: {
                        if (typeConfiguration.getCurrentBaseSqlTypeIndicators().isXmlFormatMapperLegacyFormatEnabled()) {
                            throw new IllegalArgumentException("XML array '" + columnExpression + "' in '" + aggregateParentReadExpression + "' is not supported with legacy format enabled.");
                        }
                        return template.replace(placeholder, "xmlelement(name \"Collection\",(select xmlagg(t.v order by t.i) from xmltable(" + PostgreSQLAggregateSupport.xmlExtractArguments(aggregateParentReadExpression, columnExpression + "/*") + " columns v xml path '.', i for ordinality)t))");
                    }
                    case -3: 
                    case -2: 
                    case 4003: {
                        return template.replace(placeholder, "decode((select t.v from xmltable(" + PostgreSQLAggregateSupport.xmlExtractArguments(aggregateParentReadExpression, columnExpression) + " columns v text path '.') t),'hex')");
                    }
                    case 2003: {
                        throw new UnsupportedOperationException("Transforming XML_ARRAY to native arrays is not supported on PostgreSQL!");
                    }
                }
                return template.replace(placeholder, "(select t.v from xmltable(" + PostgreSQLAggregateSupport.xmlExtractArguments(aggregateParentReadExpression, columnExpression) + " columns v " + column.getColumnDefinition() + " path '.') t)");
            }
            case 2002: 
            case 3016: 
            case 3017: {
                return template.replace(placeholder, "(" + aggregateParentReadExpression + ")." + columnExpression);
            }
        }
        throw new IllegalArgumentException("Unsupported aggregate SQL type: " + aggregateColumnTypeCode);
    }

    private static String xmlExtractArguments(String aggregateParentReadExpression, String xpathFragment) {
        Object extractArguments;
        int separatorIndex;
        if (aggregateParentReadExpression.startsWith(XML_EXTRACT_START) && aggregateParentReadExpression.endsWith(XML_EXTRACT_END) && (separatorIndex = aggregateParentReadExpression.indexOf(XML_EXTRACT_SEPARATOR)) != -1) {
            StringBuilder sb = new StringBuilder(aggregateParentReadExpression.length() - XML_EXTRACT_START.length() + xpathFragment.length());
            sb.append(aggregateParentReadExpression, XML_EXTRACT_START.length(), separatorIndex);
            sb.append('/');
            sb.append(xpathFragment);
            sb.append(aggregateParentReadExpression, separatorIndex + 2, aggregateParentReadExpression.length() - XML_EXTRACT_END.length());
            extractArguments = sb.toString();
        } else if (aggregateParentReadExpression.startsWith(XML_QUERY_START) && aggregateParentReadExpression.endsWith(XML_QUERY_END) && (separatorIndex = aggregateParentReadExpression.indexOf(XML_QUERY_SEPARATOR)) != -1) {
            StringBuilder sb = new StringBuilder(aggregateParentReadExpression.length() - XML_QUERY_START.length() + xpathFragment.length());
            sb.append(aggregateParentReadExpression, XML_QUERY_START.length(), separatorIndex);
            sb.append('/');
            sb.append(xpathFragment);
            sb.append(aggregateParentReadExpression, separatorIndex, aggregateParentReadExpression.length() - XML_QUERY_END.length());
            extractArguments = sb.toString();
        } else {
            extractArguments = "'/e/" + xpathFragment + XML_QUERY_SEPARATOR + aggregateParentReadExpression;
        }
        return extractArguments;
    }

    private static String jsonCustomWriteExpression(String customWriteExpression, JdbcMapping jdbcMapping) {
        int sqlTypeCode = jdbcMapping.getJdbcType().getDefaultSqlTypeCode();
        switch (sqlTypeCode) {
            case -3: 
            case -2: 
            case 4003: {
                return "to_jsonb(encode(" + customWriteExpression + ",'hex'))";
            }
            case 2003: {
                BasicPluralType pluralType = (BasicPluralType)jdbcMapping;
                switch (pluralType.getElementType().getJdbcType().getDefaultSqlTypeCode()) {
                    case -3: 
                    case -2: 
                    case 4003: {
                        return "to_jsonb(array(select encode(unnest(" + customWriteExpression + "),'hex')))";
                    }
                }
                return "to_jsonb(" + customWriteExpression + ")";
            }
        }
        return "to_jsonb(" + customWriteExpression + ")";
    }

    private static String xmlCustomWriteExpression(String customWriteExpression, JdbcMapping jdbcMapping) {
        int sqlTypeCode = jdbcMapping.getJdbcType().getDefaultSqlTypeCode();
        switch (sqlTypeCode) {
            case -3: 
            case -2: 
            case 4003: {
                return "encode(" + customWriteExpression + ",'hex')";
            }
        }
        return customWriteExpression;
    }

    @Override
    public String aggregateComponentAssignmentExpression(String aggregateParentAssignmentExpression, String columnExpression, int aggregateColumnTypeCode, Column column) {
        switch (aggregateColumnTypeCode) {
            case 2009: 
            case 3001: 
            case 3018: 
            case 3019: {
                return aggregateParentAssignmentExpression;
            }
            case 2002: 
            case 3016: 
            case 3017: {
                return aggregateParentAssignmentExpression + "." + columnExpression;
            }
        }
        throw new IllegalArgumentException("Unsupported aggregate SQL type: " + aggregateColumnTypeCode);
    }

    @Override
    public boolean requiresAggregateCustomWriteExpressionRenderer(int aggregateSqlTypeCode) {
        switch (aggregateSqlTypeCode) {
            case 2009: 
            case 3001: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean preferSelectAggregateMapping(int aggregateSqlTypeCode) {
        return aggregateSqlTypeCode != 2002;
    }

    @Override
    public AggregateSupport.WriteExpressionRenderer aggregateCustomWriteExpressionRenderer(SelectableMapping aggregateColumn, SelectableMapping[] columnsToUpdate, TypeConfiguration typeConfiguration) {
        int aggregateSqlTypeCode = aggregateColumn.getJdbcMapping().getJdbcType().getDefaultSqlTypeCode();
        switch (aggregateSqlTypeCode) {
            case 3001: {
                return new RootJsonWriteExpression(aggregateColumn, columnsToUpdate);
            }
            case 2009: {
                return new RootXmlWriteExpression(aggregateColumn, columnsToUpdate);
            }
        }
        throw new IllegalArgumentException("Unsupported aggregate SQL type: " + aggregateSqlTypeCode);
    }

    private static class RootJsonWriteExpression
    extends AggregateJsonWriteExpression
    implements AggregateSupport.WriteExpressionRenderer {
        private final boolean nullable;
        private final String path;

        RootJsonWriteExpression(SelectableMapping aggregateColumn, SelectableMapping[] columns) {
            this.nullable = aggregateColumn.isNullable();
            this.path = aggregateColumn.getSelectionExpression();
            this.initializeSubExpressions(columns);
        }

        @Override
        public void render(SqlAppender sqlAppender, SqlAstTranslator<?> translator, AggregateSupport.AggregateColumnWriteExpression aggregateColumnWriteExpression, String qualifier) {
            Object basePath = qualifier == null || qualifier.isBlank() ? this.path : qualifier + "." + this.path;
            if (this.nullable) {
                sqlAppender.append("coalesce(");
                sqlAppender.append((CharSequence)basePath);
                sqlAppender.append(",'{}')");
            } else {
                sqlAppender.append((CharSequence)basePath);
            }
            this.append(sqlAppender, (String)basePath, translator, aggregateColumnWriteExpression);
        }
    }

    private static class RootXmlWriteExpression
    extends AggregateXmlWriteExpression
    implements AggregateSupport.WriteExpressionRenderer {
        private final String path;

        RootXmlWriteExpression(SelectableMapping aggregateColumn, SelectableMapping[] columns) {
            super(aggregateColumn, aggregateColumn.getColumnDefinition());
            this.path = aggregateColumn.getSelectionExpression();
            this.initializeSubExpressions(aggregateColumn, columns);
        }

        @Override
        protected String getTagName() {
            return "e";
        }

        @Override
        public void render(SqlAppender sqlAppender, SqlAstTranslator<?> translator, AggregateSupport.AggregateColumnWriteExpression aggregateColumnWriteExpression, String qualifier) {
            Object basePath = qualifier == null || qualifier.isBlank() ? this.path : qualifier + "." + this.path;
            this.append(sqlAppender, "(select xmlagg(t.v) from xmltable('/" + this.getTagName() + PostgreSQLAggregateSupport.XML_QUERY_SEPARATOR + (String)basePath + PostgreSQLAggregateSupport.XML_QUERY_END, translator, aggregateColumnWriteExpression);
        }
    }

    private static class PassThroughXmlWriteExpression
    implements XmlWriteExpression {
        private final SelectableMapping selectableMapping;

        PassThroughXmlWriteExpression(SelectableMapping selectableMapping) {
            this.selectableMapping = selectableMapping;
        }

        @Override
        public void append(SqlAppender sb, String path, SqlAstTranslator<?> translator, AggregateSupport.AggregateColumnWriteExpression expression) {
            sb.append(PostgreSQLAggregateSupport.XML_QUERY_START);
            sb.append(PostgreSQLAggregateSupport.xmlExtractArguments(path, this.selectableMapping.getSelectableName()));
            sb.append(PostgreSQLAggregateSupport.XML_QUERY_END);
        }
    }

    private static class BasicXmlWriteExpression
    implements XmlWriteExpression {
        private final SelectableMapping selectableMapping;
        private final String[] customWriteExpressionParts;

        BasicXmlWriteExpression(SelectableMapping selectableMapping, String customWriteExpression) {
            this.selectableMapping = selectableMapping;
            if (customWriteExpression.equals("?")) {
                this.customWriteExpressionParts = new String[]{"", ""};
            } else {
                assert (!customWriteExpression.startsWith("?"));
                String[] parts = StringHelper.split("?", customWriteExpression);
                assert (parts.length == 2 || (parts.length & 1) == 1);
                this.customWriteExpressionParts = parts;
            }
        }

        @Override
        public void append(SqlAppender sb, String path, SqlAstTranslator<?> translator, AggregateSupport.AggregateColumnWriteExpression expression) {
            JdbcType jdbcType = this.selectableMapping.getJdbcMapping().getJdbcType();
            boolean isArray = jdbcType.getDefaultSqlTypeCode() == 3019;
            sb.append("xmlelement(name ");
            sb.appendDoubleQuoteEscapedString(this.selectableMapping.getSelectableName());
            sb.append(',');
            if (isArray) {
                sb.append("(select xmlagg(t.v order by t.i) from xmltable('/Collection/*' passing ");
            }
            sb.append(this.customWriteExpressionParts[0]);
            for (int i = 1; i < this.customWriteExpressionParts.length; ++i) {
                translator.render(expression.getValueExpression(this.selectableMapping), SqlAstNodeRenderingMode.NO_UNTYPED);
                sb.append(this.customWriteExpressionParts[i]);
            }
            if (isArray) {
                sb.append(" columns v xml path '.', i for ordinality)t)");
            }
            sb.append(')');
        }
    }

    private static class AggregateXmlWriteExpression
    implements XmlWriteExpression {
        private final SelectableMapping selectableMapping;
        private final String columnDefinition;
        private final LinkedHashMap<String, XmlWriteExpression> subExpressions = new LinkedHashMap();

        private AggregateXmlWriteExpression(SelectableMapping selectableMapping, String columnDefinition) {
            this.selectableMapping = selectableMapping;
            this.columnDefinition = columnDefinition;
        }

        protected void initializeSubExpressions(SelectableMapping aggregateColumn, SelectableMapping[] columns) {
            for (SelectableMapping column : columns) {
                SelectablePath selectablePath = column.getSelectablePath();
                SelectablePath[] parts = selectablePath.getParts();
                AggregateXmlWriteExpression currentAggregate = this;
                for (int i = 1; i < parts.length - 1; ++i) {
                    AggregateJdbcType aggregateJdbcType = (AggregateJdbcType)currentAggregate.selectableMapping.getJdbcMapping().getJdbcType();
                    EmbeddableMappingType embeddableMappingType = aggregateJdbcType.getEmbeddableMappingType();
                    int selectableIndex = embeddableMappingType.getSelectableIndex(parts[i].getSelectableName());
                    currentAggregate = (AggregateXmlWriteExpression)currentAggregate.subExpressions.computeIfAbsent(parts[i].getSelectableName(), k -> new AggregateXmlWriteExpression(embeddableMappingType.getJdbcValueSelectable(selectableIndex), this.columnDefinition));
                }
                String customWriteExpression = column.getWriteExpression();
                currentAggregate.subExpressions.put(parts[parts.length - 1].getSelectableName(), new BasicXmlWriteExpression(column, PostgreSQLAggregateSupport.xmlCustomWriteExpression(customWriteExpression, column.getJdbcMapping())));
            }
            this.passThroughUnsetSubExpressions(aggregateColumn);
        }

        protected void passThroughUnsetSubExpressions(SelectableMapping aggregateColumn) {
            AggregateJdbcType aggregateJdbcType = (AggregateJdbcType)aggregateColumn.getJdbcMapping().getJdbcType();
            EmbeddableMappingType embeddableMappingType = aggregateJdbcType.getEmbeddableMappingType();
            int jdbcValueCount = embeddableMappingType.getJdbcValueCount();
            for (int i = 0; i < jdbcValueCount; ++i) {
                SelectableMapping selectableMapping = embeddableMappingType.getJdbcValueSelectable(i);
                XmlWriteExpression xmlWriteExpression = this.subExpressions.get(selectableMapping.getSelectableName());
                if (xmlWriteExpression == null) {
                    this.subExpressions.put(selectableMapping.getSelectableName(), new PassThroughXmlWriteExpression(selectableMapping));
                    continue;
                }
                if (!(xmlWriteExpression instanceof AggregateXmlWriteExpression)) continue;
                AggregateXmlWriteExpression writeExpression = (AggregateXmlWriteExpression)xmlWriteExpression;
                writeExpression.passThroughUnsetSubExpressions(selectableMapping);
            }
        }

        protected String getTagName() {
            return this.selectableMapping.getSelectableName();
        }

        @Override
        public void append(SqlAppender sb, String path, SqlAstTranslator<?> translator, AggregateSupport.AggregateColumnWriteExpression expression) {
            sb.append("xmlelement(name ");
            sb.appendDoubleQuoteEscapedString(this.getTagName());
            sb.append(",xmlconcat");
            int separator = 40;
            for (Map.Entry<String, XmlWriteExpression> entry : this.subExpressions.entrySet()) {
                sb.append((char)separator);
                XmlWriteExpression value = entry.getValue();
                if (value instanceof AggregateXmlWriteExpression) {
                    String subPath = PostgreSQLAggregateSupport.XML_QUERY_START + PostgreSQLAggregateSupport.xmlExtractArguments(path, entry.getKey()) + PostgreSQLAggregateSupport.XML_QUERY_END;
                    value.append(sb, subPath, translator, expression);
                } else {
                    value.append(sb, path, translator, expression);
                }
                separator = 44;
            }
            sb.append("))");
        }
    }

    static interface XmlWriteExpression {
        public void append(SqlAppender var1, String var2, SqlAstTranslator<?> var3, AggregateSupport.AggregateColumnWriteExpression var4);
    }

    private static class BasicJsonWriteExpression
    implements JsonWriteExpression {
        private final SelectableMapping selectableMapping;
        private final String customWriteExpressionStart;
        private final String customWriteExpressionEnd;

        BasicJsonWriteExpression(SelectableMapping selectableMapping, String customWriteExpression) {
            this.selectableMapping = selectableMapping;
            if (customWriteExpression.equals("?")) {
                this.customWriteExpressionStart = "";
                this.customWriteExpressionEnd = "";
            } else {
                String[] parts = StringHelper.split("?", customWriteExpression);
                assert (parts.length == 2);
                this.customWriteExpressionStart = parts[0];
                this.customWriteExpressionEnd = parts[1];
            }
        }

        @Override
        public void append(SqlAppender sb, String path, SqlAstTranslator<?> translator, AggregateSupport.AggregateColumnWriteExpression expression) {
            sb.append('\'');
            sb.append(this.selectableMapping.getSelectableName());
            sb.append("',");
            sb.append(this.customWriteExpressionStart);
            translator.render(expression.getValueExpression(this.selectableMapping), SqlAstNodeRenderingMode.NO_UNTYPED);
            sb.append(this.customWriteExpressionEnd);
        }
    }

    private static class AggregateJsonWriteExpression
    implements JsonWriteExpression {
        private final LinkedHashMap<String, JsonWriteExpression> subExpressions = new LinkedHashMap();

        private AggregateJsonWriteExpression() {
        }

        protected void initializeSubExpressions(SelectableMapping[] columns) {
            for (SelectableMapping column : columns) {
                SelectablePath selectablePath = column.getSelectablePath();
                SelectablePath[] parts = selectablePath.getParts();
                AggregateJsonWriteExpression currentAggregate = this;
                for (int i = 1; i < parts.length - 1; ++i) {
                    currentAggregate = (AggregateJsonWriteExpression)currentAggregate.subExpressions.computeIfAbsent(parts[i].getSelectableName(), k -> new AggregateJsonWriteExpression());
                }
                String customWriteExpression = column.getWriteExpression();
                currentAggregate.subExpressions.put(parts[parts.length - 1].getSelectableName(), new BasicJsonWriteExpression(column, PostgreSQLAggregateSupport.jsonCustomWriteExpression(customWriteExpression, column.getJdbcMapping())));
            }
        }

        @Override
        public void append(SqlAppender sb, String path, SqlAstTranslator<?> translator, AggregateSupport.AggregateColumnWriteExpression expression) {
            sb.append("||jsonb_build_object");
            int separator = 40;
            for (Map.Entry<String, JsonWriteExpression> entry : this.subExpressions.entrySet()) {
                String column = entry.getKey();
                JsonWriteExpression value = entry.getValue();
                String subPath = path + "->'" + column + "'";
                sb.append((char)separator);
                if (value instanceof AggregateJsonWriteExpression) {
                    sb.append('\'');
                    sb.append(column);
                    sb.append("',coalesce(");
                    sb.append(subPath);
                    sb.append(",'{}')");
                    value.append(sb, subPath, translator, expression);
                } else {
                    value.append(sb, subPath, translator, expression);
                }
                separator = 44;
            }
            sb.append(')');
        }
    }

    static interface JsonWriteExpression {
        public void append(SqlAppender var1, String var2, SqlAstTranslator<?> var3, AggregateSupport.AggregateColumnWriteExpression var4);
    }
}

