/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.Internal;
import org.hibernate.Version;
import org.hibernate.cfg.AvailableSettings;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.ConfigHelper;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.jboss.logging.Logger;

@Internal
public final class Environment
implements AvailableSettings {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger((MethodHandles.Lookup)MethodHandles.lookup(), CoreMessageLogger.class, (String)Environment.class.getName());
    private static final Properties GLOBAL_PROPERTIES;

    private Environment() {
    }

    public static Properties getProperties() {
        Properties copy = new Properties();
        copy.putAll((Map<?, ?>)GLOBAL_PROPERTIES);
        return copy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Version.logVersion();
        GLOBAL_PROPERTIES = new Properties();
        try {
            InputStream stream = ConfigHelper.getResourceAsStream("/hibernate.properties");
            try {
                GLOBAL_PROPERTIES.load(stream);
                LOG.propertiesLoaded(ConfigurationHelper.maskOut(GLOBAL_PROPERTIES, "hibernate.connection.password", "jakarta.persistence.jdbc.password", "javax.persistence.jdbc.password"));
            }
            catch (Exception e) {
                LOG.unableToLoadProperties();
            }
            finally {
                try {
                    stream.close();
                }
                catch (IOException ioe) {
                    LOG.unableToCloseStreamError(ioe);
                }
            }
        }
        catch (HibernateException he) {
            LOG.propertiesNotFound();
        }
        try {
            Properties systemProperties;
            Properties properties = systemProperties = System.getProperties();
            synchronized (properties) {
                GLOBAL_PROPERTIES.putAll((Map<?, ?>)systemProperties);
            }
        }
        catch (SecurityException se) {
            LOG.unableToCopySystemProperties();
        }
    }
}

