/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.enhance.internal.tracker;

import java.util.Arrays;
import org.hibernate.bytecode.enhance.spi.CollectionTracker;
import org.hibernate.internal.util.collections.ArrayHelper;

public final class SimpleCollectionTracker
implements CollectionTracker {
    private String[] names = ArrayHelper.EMPTY_STRING_ARRAY;
    private int[] sizes = ArrayHelper.EMPTY_INT_ARRAY;

    @Override
    public void add(String name, int size) {
        for (int i = 0; i < this.names.length; ++i) {
            if (!this.names[i].equals(name)) continue;
            this.sizes[i] = size;
            return;
        }
        this.names = Arrays.copyOf(this.names, this.names.length + 1);
        this.names[this.names.length - 1] = name;
        this.sizes = Arrays.copyOf(this.sizes, this.sizes.length + 1);
        this.sizes[this.sizes.length - 1] = size;
    }

    @Override
    public int getSize(String name) {
        for (int i = 0; i < this.names.length; ++i) {
            if (!name.equals(this.names[i])) continue;
            return this.sizes[i];
        }
        return -1;
    }
}

