/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.annotations.internal;

import jakarta.persistence.AttributeConverter;
import java.lang.annotation.Annotation;
import java.util.Map;
import org.hibernate.annotations.SoftDelete;
import org.hibernate.annotations.SoftDeleteType;
import org.hibernate.models.spi.ModelsContext;

public class SoftDeleteAnnotation
implements SoftDelete {
    private String columnName;
    private String options;
    private String comment;
    private SoftDeleteType strategy;
    private Class<? extends AttributeConverter<Boolean, ?>> converter;

    public SoftDeleteAnnotation(ModelsContext modelContext) {
        this.columnName = "";
        this.strategy = SoftDeleteType.DELETED;
        this.converter = SoftDelete.UnspecifiedConversion.class;
    }

    public SoftDeleteAnnotation(SoftDelete annotation, ModelsContext modelContext) {
        this.columnName = annotation.columnName();
        this.strategy = annotation.strategy();
        this.options = annotation.options();
        this.comment = annotation.comment();
        this.converter = annotation.converter();
    }

    public SoftDeleteAnnotation(Map<String, Object> attributeValues, ModelsContext modelContext) {
        this.columnName = (String)attributeValues.get("columnName");
        this.strategy = (SoftDeleteType)((Object)attributeValues.get("strategy"));
        this.options = (String)attributeValues.get("options");
        this.comment = (String)attributeValues.get("comment");
        this.converter = (Class)attributeValues.get("converter");
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return SoftDelete.class;
    }

    @Override
    public String columnName() {
        return this.columnName;
    }

    public void columnName(String value) {
        this.columnName = value;
    }

    @Override
    public String options() {
        return this.options;
    }

    public void options(String options) {
        this.options = options;
    }

    @Override
    public String comment() {
        return this.comment;
    }

    public void comment(String comment) {
        this.comment = comment;
    }

    @Override
    public SoftDeleteType strategy() {
        return this.strategy;
    }

    public void strategy(SoftDeleteType value) {
        this.strategy = value;
    }

    @Override
    public Class<? extends AttributeConverter<Boolean, ?>> converter() {
        return this.converter;
    }

    public void converter(Class<? extends AttributeConverter<Boolean, ?>> value) {
        this.converter = value;
    }
}

