/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.annotations.internal;

import jakarta.persistence.NamedAttributeNode;
import jakarta.persistence.NamedSubgraph;
import java.lang.annotation.Annotation;
import java.util.Map;
import org.hibernate.boot.models.JpaAnnotations;
import org.hibernate.boot.models.internal.OrmAnnotationHelper;
import org.hibernate.models.spi.ModelsContext;

public class NamedSubgraphJpaAnnotation
implements NamedSubgraph {
    private String name;
    private Class<?> type;
    private NamedAttributeNode[] attributeNodes;

    public NamedSubgraphJpaAnnotation(ModelsContext modelContext) {
        this.type = Void.TYPE;
    }

    public NamedSubgraphJpaAnnotation(NamedSubgraph annotation, ModelsContext modelContext) {
        this.name = annotation.name();
        this.type = annotation.type();
        this.attributeNodes = (NamedAttributeNode[])OrmAnnotationHelper.extractJdkValue(annotation, JpaAnnotations.NAMED_SUBGRAPH, "attributeNodes", modelContext);
    }

    public NamedSubgraphJpaAnnotation(Map<String, Object> attributeValues, ModelsContext modelContext) {
        this.name = (String)attributeValues.get("name");
        this.type = (Class)attributeValues.get("type");
        this.attributeNodes = (NamedAttributeNode[])attributeValues.get("attributeNodes");
    }

    public Class<? extends Annotation> annotationType() {
        return NamedSubgraph.class;
    }

    public String name() {
        return this.name;
    }

    public void name(String value) {
        this.name = value;
    }

    public Class<?> type() {
        return this.type;
    }

    public void type(Class<?> value) {
        this.type = value;
    }

    public NamedAttributeNode[] attributeNodes() {
        return this.attributeNodes;
    }

    public void attributeNodes(NamedAttributeNode[] value) {
        this.attributeNodes = value;
    }
}

