/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.annotations.internal;

import java.lang.annotation.Annotation;
import java.util.Map;
import org.hibernate.annotations.CollectionType;
import org.hibernate.annotations.Parameter;
import org.hibernate.boot.models.HibernateAnnotations;
import org.hibernate.boot.models.internal.OrmAnnotationHelper;
import org.hibernate.models.spi.ModelsContext;
import org.hibernate.usertype.UserCollectionType;

public class CollectionTypeAnnotation
implements CollectionType {
    private Class<? extends UserCollectionType> type;
    private Parameter[] parameters;

    public CollectionTypeAnnotation(ModelsContext modelContext) {
        this.parameters = new Parameter[0];
    }

    public CollectionTypeAnnotation(CollectionType annotation, ModelsContext modelContext) {
        this.type = annotation.type();
        this.parameters = (Parameter[])OrmAnnotationHelper.extractJdkValue(annotation, HibernateAnnotations.COLLECTION_TYPE, "parameters", modelContext);
    }

    public CollectionTypeAnnotation(Map<String, Object> attributeValues, ModelsContext modelContext) {
        this.type = (Class)attributeValues.get("type");
        this.parameters = (Parameter[])attributeValues.get("parameters");
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return CollectionType.class;
    }

    @Override
    public Class<? extends UserCollectionType> type() {
        return this.type;
    }

    public void type(Class<? extends UserCollectionType> value) {
        this.type = value;
    }

    @Override
    public Parameter[] parameters() {
        return this.parameters;
    }

    public void parameters(Parameter[] value) {
        this.parameters = value;
    }
}

