/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.process.internal;

import jakarta.persistence.EnumType;
import jakarta.persistence.EnumeratedValue;
import jakarta.persistence.TemporalType;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Locale;
import java.util.function.Function;
import java.util.function.Supplier;
import org.hibernate.MappingException;
import org.hibernate.boot.model.process.internal.EnumeratedValueConverter;
import org.hibernate.boot.model.process.internal.InferredBasicValueResolution;
import org.hibernate.boot.spi.BootstrapContext;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.dialect.Dialect;
import org.hibernate.mapping.BasicValue;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.Table;
import org.hibernate.tool.schema.extract.spi.ColumnTypeInformation;
import org.hibernate.type.AdjustableBasicType;
import org.hibernate.type.BasicPluralType;
import org.hibernate.type.BasicType;
import org.hibernate.type.BasicTypeRegistry;
import org.hibernate.type.SerializableType;
import org.hibernate.type.descriptor.java.BasicJavaType;
import org.hibernate.type.descriptor.java.BasicPluralJavaType;
import org.hibernate.type.descriptor.java.EnumJavaType;
import org.hibernate.type.descriptor.java.ImmutableMutabilityPlan;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.JavaTypeHelper;
import org.hibernate.type.descriptor.java.MutabilityPlan;
import org.hibernate.type.descriptor.java.SerializableJavaType;
import org.hibernate.type.descriptor.java.TemporalJavaType;
import org.hibernate.type.descriptor.java.spi.JdbcTypeRecommendationException;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeIndicators;
import org.hibernate.type.descriptor.jdbc.ObjectJdbcType;
import org.hibernate.type.descriptor.jdbc.spi.JdbcTypeRegistry;
import org.hibernate.type.internal.ConvertedBasicTypeImpl;
import org.hibernate.type.spi.TypeConfiguration;

public class InferredBasicValueResolver {
    public static <T> BasicValue.Resolution<T> from(BasicJavaType<T> explicitJavaType, JdbcType explicitJdbcType, Type resolvedJavaType, Supplier<JavaType<T>> reflectedJtdResolver, Function<TypeConfiguration, MutabilityPlan<?>> explicitMutabilityPlanAccess, JdbcTypeIndicators stdIndicators, Table table, Selectable selectable, String ownerName, String propertyName, MetadataBuildingContext buildingContext) {
        BasicType<Object> jdbcMapping;
        BootstrapContext bootstrapContext = buildingContext.getBootstrapContext();
        TypeConfiguration typeConfiguration = bootstrapContext.getTypeConfiguration();
        BasicTypeRegistry basicTypeRegistry = typeConfiguration.getBasicTypeRegistry();
        JavaType<T> reflectedJtd = reflectedJtdResolver.get();
        if (explicitJavaType != null) {
            JdbcType inferredJdbcType;
            if (JavaTypeHelper.isTemporal(explicitJavaType)) {
                return InferredBasicValueResolver.fromTemporal((TemporalJavaType)explicitJavaType, null, explicitJdbcType, explicitMutabilityPlanAccess, stdIndicators);
            }
            jdbcMapping = explicitJdbcType != null ? basicTypeRegistry.resolve(explicitJavaType, explicitJdbcType) : ((inferredJdbcType = explicitJavaType.getRecommendedJdbcType(stdIndicators)) instanceof ObjectJdbcType && (explicitJavaType instanceof SerializableJavaType || explicitJavaType.getJavaType() instanceof Serializable) ? new SerializableType<T>(explicitJavaType) : InferredBasicValueResolver.resolveSqlTypeIndicators(stdIndicators, basicTypeRegistry.resolve(explicitJavaType, inferredJdbcType), explicitJavaType));
        } else if (reflectedJtd != null) {
            if (reflectedJtd instanceof EnumJavaType) {
                EnumJavaType enumJavaType = (EnumJavaType)reflectedJtd;
                return InferredBasicValueResolver.fromEnum(enumJavaType, explicitJdbcType, stdIndicators, bootstrapContext);
            }
            if (JavaTypeHelper.isTemporal(reflectedJtd)) {
                return InferredBasicValueResolver.fromTemporal((TemporalJavaType)reflectedJtd, null, explicitJdbcType, explicitMutabilityPlanAccess, stdIndicators);
            }
            if (explicitJdbcType != null) {
                jdbcMapping = basicTypeRegistry.resolve(reflectedJtd, explicitJdbcType);
            } else {
                BasicType<?> registeredType = InferredBasicValueResolver.registeredType(explicitJdbcType, explicitMutabilityPlanAccess, stdIndicators, selectable, reflectedJtd, bootstrapContext, buildingContext.getMetadataCollector().getDatabase().getDialect());
                if (registeredType != null) {
                    jdbcMapping = InferredBasicValueResolver.resolveSqlTypeIndicators(stdIndicators, registeredType, reflectedJtd);
                } else {
                    JdbcType recommendedJdbcType;
                    try {
                        recommendedJdbcType = reflectedJtd.getRecommendedJdbcType(stdIndicators);
                    }
                    catch (JdbcTypeRecommendationException jtre) {
                        if (buildingContext.getMetadataCollector().getEntityBindingMap().values().stream().anyMatch(pc -> pc.getMappedClass().equals(resolvedJavaType))) {
                            throw new MappingException("Incorrect use of entity type '" + resolvedJavaType.getTypeName() + "' (possibly due to missing association mapping annotation)", (Throwable)((Object)jtre));
                        }
                        throw jtre;
                    }
                    jdbcMapping = recommendedJdbcType != null ? InferredBasicValueResolver.resolveSqlTypeIndicators(stdIndicators, basicTypeRegistry.resolve(reflectedJtd, recommendedJdbcType), reflectedJtd) : (reflectedJtd instanceof SerializableJavaType || Serializable.class.isAssignableFrom(reflectedJtd.getJavaTypeClass()) ? new SerializableType<T>(reflectedJtd) : null);
                }
            }
        } else if (explicitJdbcType != null) {
            Integer length = null;
            Integer scale = null;
            if (selectable instanceof Column) {
                Column column = (Column)selectable;
                if (column.getPrecision() != null && column.getPrecision() > 0) {
                    length = column.getPrecision();
                    scale = column.getScale();
                } else if (column.getLength() != null) {
                    length = column.getLength() > Integer.MAX_VALUE ? Integer.valueOf(Integer.MAX_VALUE) : Integer.valueOf(column.getLength().intValue());
                }
            }
            JavaType recommendedJtd = explicitJdbcType.getJdbcRecommendedJavaTypeMapping(length, scale, typeConfiguration);
            jdbcMapping = InferredBasicValueResolver.resolveSqlTypeIndicators(stdIndicators, basicTypeRegistry.resolve(recommendedJtd, explicitJdbcType), recommendedJtd);
        } else {
            throw new MappingException("Could not determine JavaType nor JdbcType to use for BasicValue: owner = " + ownerName + "; property = " + propertyName + "; table = " + table.getName() + "; column = " + selectable.getText());
        }
        if (jdbcMapping == null) {
            throw new MappingException("Could not determine JavaType nor JdbcType to use for " + String.valueOf(((BasicValue)stdIndicators).getResolvedJavaType()) + "; table = " + table.getName() + "; column = " + selectable.getText());
        }
        return new InferredBasicValueResolution<T, T>(jdbcMapping, jdbcMapping.getJavaTypeDescriptor(), jdbcMapping.getJavaTypeDescriptor(), jdbcMapping.getJdbcType(), jdbcMapping, InferredBasicValueResolver.determineMutabilityPlan(explicitMutabilityPlanAccess, jdbcMapping.getJavaTypeDescriptor(), typeConfiguration));
    }

    private static <T> BasicType<?> registeredType(JdbcType explicitJdbcType, Function<TypeConfiguration, MutabilityPlan<?>> explicitMutabilityPlanAccess, JdbcTypeIndicators stdIndicators, Selectable selectable, JavaType<T> reflectedJtd, BootstrapContext bootstrapContext, Dialect dialect) {
        TypeConfiguration typeConfiguration = bootstrapContext.getTypeConfiguration();
        if (reflectedJtd instanceof BasicPluralJavaType) {
            ColumnTypeInformation information;
            BasicType<?> registeredType;
            BasicPluralJavaType pluralJavaType = (BasicPluralJavaType)((Object)reflectedJtd);
            JavaType elementJavaType = pluralJavaType.getElementJavaType();
            BasicType<?> registeredElementType = InferredBasicValueResolver.registeredElementType(explicitJdbcType, explicitMutabilityPlanAccess, stdIndicators, bootstrapContext, elementJavaType);
            BasicType<?> basicType = registeredElementType == null ? null : (registeredType = pluralJavaType.resolveType(typeConfiguration, dialect, InferredBasicValueResolver.resolveSqlTypeIndicators(stdIndicators, registeredElementType, elementJavaType), selectable instanceof ColumnTypeInformation ? (information = (ColumnTypeInformation)((Object)selectable)) : null, stdIndicators));
            if (registeredType instanceof BasicPluralType) {
                typeConfiguration.getBasicTypeRegistry().register(registeredType);
            }
            return registeredType;
        }
        return typeConfiguration.getBasicTypeRegistry().getRegisteredType(reflectedJtd.getJavaType());
    }

    private static BasicType<?> registeredElementType(JdbcType explicitJdbcType, Function<TypeConfiguration, MutabilityPlan<?>> explicitMutabilityPlanAccess, JdbcTypeIndicators stdIndicators, BootstrapContext context, JavaType<?> elementJtd) {
        if (elementJtd instanceof EnumJavaType) {
            EnumJavaType enumJavaType = (EnumJavaType)elementJtd;
            return (BasicType)InferredBasicValueResolver.fromEnum(enumJavaType, explicitJdbcType, stdIndicators, context).getJdbcMapping();
        }
        if (JavaTypeHelper.isTemporal(elementJtd)) {
            BasicValue.Resolution resolution = InferredBasicValueResolver.fromTemporal((TemporalJavaType)elementJtd, null, null, explicitMutabilityPlanAccess, stdIndicators);
            return resolution.getLegacyResolvedBasicType();
        }
        return context.getTypeConfiguration().getBasicTypeRegistry().getRegisteredType(elementJtd.getJavaType());
    }

    public static <T> BasicType<T> resolveSqlTypeIndicators(JdbcTypeIndicators stdIndicators, BasicType<T> resolved, JavaType<T> domainJtd) {
        if (resolved instanceof AdjustableBasicType) {
            AdjustableBasicType indicatorCapable = (AdjustableBasicType)resolved;
            BasicType<T> indicatedType = indicatorCapable.resolveIndicatedType(stdIndicators, domainJtd);
            return indicatedType != null ? indicatedType : resolved;
        }
        return resolved;
    }

    public static <E extends Enum<E>> BasicValue.Resolution<E> fromEnum(EnumJavaType<E> enumJavaType, JdbcType explicitJdbcType, JdbcTypeIndicators stdIndicators, BootstrapContext context) {
        Field enumeratedValueField = InferredBasicValueResolver.determineEnumeratedValueField(enumJavaType.getJavaTypeClass());
        if (enumeratedValueField != null) {
            InferredBasicValueResolver.validateEnumeratedValue(enumeratedValueField, stdIndicators);
        }
        JdbcType jdbcType = InferredBasicValueResolver.enumJdbcType(enumJavaType, explicitJdbcType, stdIndicators, context, enumeratedValueField);
        BasicType<E> basicType = enumeratedValueField != null ? InferredBasicValueResolver.createEnumeratedValueJdbcMapping(enumeratedValueField, enumJavaType, jdbcType, context) : context.getTypeConfiguration().getBasicTypeRegistry().resolve(enumJavaType, jdbcType);
        context.registerAdHocBasicType(basicType);
        return new InferredBasicValueResolution<E, E>(basicType, enumJavaType, enumJavaType, jdbcType, basicType, ImmutableMutabilityPlan.instance());
    }

    private static <E extends Enum<E>> JdbcType enumJdbcType(EnumJavaType<E> enumJavaType, JdbcType explicitJdbcType, JdbcTypeIndicators stdIndicators, BootstrapContext context, Field enumeratedValueField) {
        if (explicitJdbcType != null) {
            return explicitJdbcType;
        }
        if (enumeratedValueField != null) {
            JdbcTypeRegistry jdbcTypeRegistry = context.getTypeConfiguration().getJdbcTypeRegistry();
            Class<?> fieldType = enumeratedValueField.getType();
            if (String.class.equals(fieldType)) {
                return jdbcTypeRegistry.getDescriptor(12);
            }
            if (Byte.TYPE.equals(fieldType)) {
                return jdbcTypeRegistry.getDescriptor(-6);
            }
            if (Short.TYPE.equals(fieldType) || Integer.TYPE.equals(fieldType)) {
                return jdbcTypeRegistry.getDescriptor(5);
            }
            throw new IllegalStateException();
        }
        return enumJavaType.getRecommendedJdbcType(stdIndicators);
    }

    private static <E extends Enum<E>> BasicType<E> createEnumeratedValueJdbcMapping(Field enumeratedValueField, EnumJavaType<E> enumJavaType, JdbcType jdbcType, BootstrapContext context) {
        JavaType relationalJavaType = context.getTypeConfiguration().getJavaTypeRegistry().getDescriptor(enumeratedValueField.getType());
        return new ConvertedBasicTypeImpl<E>("convertedBasicType" + enumJavaType.getTypeName(), "EnumeratedValue conversion for " + enumJavaType.getTypeName(), jdbcType, new EnumeratedValueConverter(enumJavaType, relationalJavaType, enumeratedValueField));
    }

    private static <E extends Enum<E>> Field determineEnumeratedValueField(Class<E> enumJavaTypeClass) {
        for (Field field : enumJavaTypeClass.getDeclaredFields()) {
            if (!field.isAnnotationPresent(EnumeratedValue.class)) continue;
            return field;
        }
        return null;
    }

    private static void validateEnumeratedValue(Field enumeratedValueField, JdbcTypeIndicators stdIndicators) {
        Class<?> fieldType = enumeratedValueField.getType();
        if (stdIndicators.getEnumeratedType() == EnumType.STRING) {
            if (!String.class.equals(fieldType) && !Character.TYPE.equals(fieldType)) {
                throw new MappingException(String.format(Locale.ROOT, "@EnumeratedValue for EnumType.STRING must be placed on a field whose type is String or char: %s.%s", enumeratedValueField.getDeclaringClass().getName(), enumeratedValueField.getName()));
            }
        } else {
            assert (stdIndicators.getEnumeratedType() == null || stdIndicators.getEnumeratedType() == EnumType.ORDINAL);
            if (!(Byte.TYPE.equals(fieldType) || Short.TYPE.equals(fieldType) || Integer.TYPE.equals(fieldType))) {
                throw new MappingException(String.format(Locale.ROOT, "@EnumeratedValue for EnumType.ORDINAL must be placed on a field whose type is byte, short, or int: %s.%s", enumeratedValueField.getDeclaringClass().getName(), enumeratedValueField.getName()));
            }
        }
    }

    public static <T> BasicValue.Resolution<T> fromTemporal(TemporalJavaType<T> reflectedJtd, BasicJavaType<?> explicitJavaType, JdbcType explicitJdbcType, Function<TypeConfiguration, MutabilityPlan<?>> explicitMutabilityPlanAccess, JdbcTypeIndicators stdIndicators) {
        TypeConfiguration typeConfiguration = stdIndicators.getTypeConfiguration();
        BasicTypeRegistry basicTypeRegistry = typeConfiguration.getBasicTypeRegistry();
        TemporalType requestedTemporalPrecision = stdIndicators.getTemporalPrecision();
        if (explicitJavaType != null) {
            if (!JavaTypeHelper.isTemporal(explicitJavaType)) {
                throw new MappingException("Explicit JavaType [" + String.valueOf(explicitJavaType) + "] defined for temporal value must implement TemporalJavaType");
            }
            TemporalJavaType explicitTemporalJtd = (TemporalJavaType)explicitJavaType;
            if (requestedTemporalPrecision != null && explicitTemporalJtd.getPrecision() != requestedTemporalPrecision) {
                throw new MappingException("Temporal precision (`jakarta.persistence.TemporalType`) mismatch... requested precision = " + String.valueOf(requestedTemporalPrecision) + "; explicit JavaType (`" + String.valueOf(explicitTemporalJtd) + "`) precision = " + String.valueOf(explicitTemporalJtd.getPrecision()));
            }
            JdbcType jdbcType = explicitJdbcType != null ? explicitJdbcType : explicitTemporalJtd.getRecommendedJdbcType(stdIndicators);
            BasicType jdbcMapping = basicTypeRegistry.resolve(explicitTemporalJtd, jdbcType);
            return new InferredBasicValueResolution(jdbcMapping, explicitTemporalJtd, explicitTemporalJtd, jdbcType, jdbcMapping, InferredBasicValueResolver.determineMutabilityPlan(explicitMutabilityPlanAccess, explicitTemporalJtd, typeConfiguration));
        }
        if (explicitJdbcType != null) {
            TemporalJavaType temporalJavaType = requestedTemporalPrecision != null ? reflectedJtd.resolveTypeForPrecision(requestedTemporalPrecision, typeConfiguration) : reflectedJtd.resolveTypeForPrecision(reflectedJtd.getPrecision(), typeConfiguration);
            BasicType jdbcMapping = basicTypeRegistry.resolve(temporalJavaType, explicitJdbcType);
            return new InferredBasicValueResolution(jdbcMapping, temporalJavaType, temporalJavaType, explicitJdbcType, jdbcMapping, temporalJavaType.getMutabilityPlan());
        }
        BasicType basicType = requestedTemporalPrecision != null && requestedTemporalPrecision != reflectedJtd.getPrecision() ? basicTypeRegistry.resolve(reflectedJtd.resolveTypeForPrecision(requestedTemporalPrecision, typeConfiguration), TemporalJavaType.resolveJdbcTypeCode(requestedTemporalPrecision)) : basicTypeRegistry.resolve(reflectedJtd.resolveTypeForPrecision(reflectedJtd.getPrecision(), typeConfiguration), reflectedJtd.getRecommendedJdbcType(stdIndicators));
        return new InferredBasicValueResolution(basicType, basicType.getJavaTypeDescriptor(), basicType.getJavaTypeDescriptor(), basicType.getJdbcType(), basicType, InferredBasicValueResolver.determineMutabilityPlan(explicitMutabilityPlanAccess, reflectedJtd, typeConfiguration));
    }

    private static <T> MutabilityPlan<T> determineMutabilityPlan(Function<TypeConfiguration, MutabilityPlan<?>> explicitMutabilityPlanAccess, JavaType<T> javaType, TypeConfiguration typeConfiguration) {
        MutabilityPlan<?> mutabilityPlan;
        if (explicitMutabilityPlanAccess != null && (mutabilityPlan = explicitMutabilityPlanAccess.apply(typeConfiguration)) != null) {
            return mutabilityPlan;
        }
        return javaType.getMutabilityPlan();
    }
}

