/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.vault;

import java.nio.CharBuffer;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import org.keycloak.vault.VaultCharSecret;

public class DefaultVaultCharSecret
implements VaultCharSecret {
    private static final VaultCharSecret EMPTY_VAULT_SECRET = new VaultCharSecret(){

        public Optional<CharBuffer> get() {
            return Optional.empty();
        }

        public Optional<char[]> getAsArray() {
            return Optional.empty();
        }

        public void close() {
        }
    };
    private final CharBuffer buffer;
    private char[] secretArray;

    public static VaultCharSecret forBuffer(Optional<CharBuffer> buffer) {
        if (buffer == null || !buffer.isPresent()) {
            return EMPTY_VAULT_SECRET;
        }
        return new DefaultVaultCharSecret(buffer.get());
    }

    private DefaultVaultCharSecret(CharBuffer buffer) {
        this.buffer = buffer;
    }

    public Optional<CharBuffer> get() {
        return Optional.of(this.buffer);
    }

    public Optional<char[]> getAsArray() {
        if (this.secretArray == null) {
            if (this.buffer.hasArray()) {
                this.secretArray = this.buffer.array();
            } else {
                this.secretArray = new char[this.buffer.capacity()];
                this.buffer.get(this.secretArray);
            }
        }
        return Optional.of(this.secretArray);
    }

    public void close() {
        if (this.buffer.hasArray()) {
            char[] internalArray = this.buffer.array();
            for (int i = 0; i < internalArray.length; ++i) {
                internalArray[i] = (char)ThreadLocalRandom.current().nextInt();
            }
        } else if (this.secretArray != null) {
            for (int i = 0; i < this.secretArray.length; ++i) {
                this.secretArray[i] = (char)ThreadLocalRandom.current().nextInt();
            }
        }
        this.buffer.clear();
    }
}

