/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.timer.basic;

import java.util.Timer;
import java.util.TimerTask;
import org.jboss.logging.Logger;
import org.keycloak.models.KeycloakSession;
import org.keycloak.services.scheduled.ScheduledTaskRunner;
import org.keycloak.timer.ScheduledTask;
import org.keycloak.timer.TimerProvider;
import org.keycloak.timer.basic.BasicTimerProviderFactory;
import org.keycloak.timer.basic.TimerTaskContextImpl;

public class BasicTimerProvider
implements TimerProvider {
    private static final Logger logger = Logger.getLogger(BasicTimerProvider.class);
    private final KeycloakSession session;
    private final Timer timer;
    private final int transactionTimeout;
    private final BasicTimerProviderFactory factory;

    public BasicTimerProvider(KeycloakSession session, Timer timer, int transactionTimeout, BasicTimerProviderFactory factory) {
        this.session = session;
        this.timer = timer;
        this.transactionTimeout = transactionTimeout;
        this.factory = factory;
    }

    public void schedule(Runnable runnable, long intervalMillis, String taskName) {
        BasicTimerTask task = new BasicTimerTask(runnable);
        TimerTaskContextImpl taskContext = new TimerTaskContextImpl(runnable, task, intervalMillis);
        TimerTaskContextImpl existingTask = this.factory.putTask(taskName, taskContext);
        if (existingTask != null) {
            logger.debugf("Existing timer task '%s' found. Cancelling it", (Object)taskName);
            existingTask.timerTask.cancel();
        }
        logger.debugf("Starting task '%s' with interval '%d'", (Object)taskName, (Object)intervalMillis);
        this.timer.schedule((TimerTask)task, intervalMillis, intervalMillis);
    }

    public void scheduleTask(ScheduledTask scheduledTask, long intervalMillis, String taskName) {
        ScheduledTaskRunner scheduledTaskRunner = new ScheduledTaskRunner(this.session.getKeycloakSessionFactory(), scheduledTask, this.transactionTimeout);
        this.schedule((Runnable)scheduledTaskRunner, intervalMillis, taskName);
    }

    public TimerProvider.TimerTaskContext cancelTask(String taskName) {
        TimerTaskContextImpl existingTask = this.factory.removeTask(taskName);
        if (existingTask != null) {
            logger.debugf("Cancelling task '%s'", (Object)taskName);
            existingTask.timerTask.cancel();
        }
        return existingTask;
    }

    public void close() {
    }

    private static class BasicTimerTask
    extends TimerTask {
        private final Runnable runnable;

        public BasicTimerTask(Runnable runnable) {
            this.runnable = runnable;
        }

        @Override
        public void run() {
            this.runnable.run();
        }
    }
}

