/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.theme.beans;

import jakarta.ws.rs.core.UriBuilder;
import java.text.Bidi;
import java.text.Collator;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.keycloak.models.RealmModel;

public class LocaleBean {
    private final String current;
    private final String currentLanguageTag;
    private final boolean rtl;
    private final List<Locale> supported;
    private static final ConcurrentHashMap<String, Boolean> bidiMap = new ConcurrentHashMap();

    public LocaleBean(RealmModel realm, java.util.Locale current, UriBuilder uriBuilder, Properties messages) {
        this.currentLanguageTag = current.toLanguageTag();
        this.current = messages.getProperty("locale_" + this.currentLanguageTag, this.currentLanguageTag);
        this.rtl = !LocaleBean.isLeftToRight(this.current);
        Collator collator = Collator.getInstance(current);
        collator.setStrength(0);
        this.supported = realm.getSupportedLocalesStream().map(l -> {
            String label = messages.getProperty("locale_" + l, (String)l);
            String url = uriBuilder.replaceQueryParam("kc_locale", new Object[]{l}).build(new Object[0]).toString();
            return new Locale((String)l, label, url);
        }).sorted((o1, o2) -> collator.compare(o1.label, o2.label)).collect(Collectors.toList());
    }

    protected static boolean isLeftToRight(String current) {
        return bidiMap.computeIfAbsent(current, l -> new Bidi((String)l, -2).isLeftToRight());
    }

    public String getCurrent() {
        return this.current;
    }

    public String getCurrentLanguageTag() {
        return this.currentLanguageTag;
    }

    public boolean isRtl() {
        return this.rtl;
    }

    public List<Locale> getSupported() {
        return this.supported;
    }

    public static class Locale {
        private final String languageTag;
        private final String label;
        private final String url;

        public Locale(String languageTag, String label, String url) {
            this.languageTag = languageTag;
            this.label = label;
            this.url = url;
        }

        public String getLanguageTag() {
            return this.languageTag;
        }

        public String getUrl() {
            return this.url;
        }

        public String getLabel() {
            return this.label;
        }
    }
}

