/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.util;

import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import org.jboss.logging.Logger;
import org.keycloak.common.util.Base64Url;
import org.keycloak.http.HttpRequest;
import org.keycloak.models.KeycloakSession;
import org.keycloak.representations.AccessToken;
import org.keycloak.services.x509.X509ClientCertificateLookup;

public class MtlsHoKTokenUtil {
    protected static final Logger logger = Logger.getLogger(MtlsHoKTokenUtil.class);
    private static final String DIGEST_ALG = "SHA-256";
    public static final String CERT_VERIFY_ERROR_DESC = "Client certificate missing, or its thumbprint and one in the refresh token did NOT match";

    public static AccessToken.Confirmation bindTokenWithClientCertificate(HttpRequest request, KeycloakSession session) {
        X509Certificate[] certs = MtlsHoKTokenUtil.getCertificateChain(request, session);
        if (certs == null || certs.length < 1) {
            logger.warnf("no client certificate available.", new Object[0]);
            return null;
        }
        String DERX509Base64UrlEncoded = null;
        try {
            DERX509Base64UrlEncoded = MtlsHoKTokenUtil.getCertificateThumbprintInSHA256DERX509Base64UrlEncoded(certs[0]);
            if (logger.isTraceEnabled()) {
                MtlsHoKTokenUtil.dumpCertInfo(certs);
            }
        }
        catch (NoSuchAlgorithmException | CertificateEncodingException e) {
            logger.warnf("give up issuing hok token. %s", (Object)e);
            return null;
        }
        AccessToken.Confirmation confirmation = new AccessToken.Confirmation();
        confirmation.setCertThumbprint(DERX509Base64UrlEncoded);
        return confirmation;
    }

    public static boolean verifyTokenBindingWithClientCertificate(AccessToken token, HttpRequest request, KeycloakSession session) {
        if (token == null) {
            logger.warnf("token is null", new Object[0]);
            return false;
        }
        if (token.getConfirmation() == null) {
            logger.warnf("bearer token received instead of hok token.", new Object[0]);
            return false;
        }
        X509Certificate[] certs = MtlsHoKTokenUtil.getCertificateChain(request, session);
        if (certs == null || certs.length < 1) {
            logger.warnf("missing client certificate.", new Object[0]);
            return false;
        }
        String DERX509Base64UrlEncoded = null;
        String x5ts256 = token.getConfirmation().getCertThumbprint();
        logger.tracef("hok token cnf-x5t#s256 = %s", (Object)x5ts256);
        try {
            DERX509Base64UrlEncoded = MtlsHoKTokenUtil.getCertificateThumbprintInSHA256DERX509Base64UrlEncoded(certs[0]);
            if (logger.isTraceEnabled()) {
                MtlsHoKTokenUtil.dumpCertInfo(certs);
            }
        }
        catch (NoSuchAlgorithmException | CertificateEncodingException e) {
            logger.warnf("client certificate exception. %s", (Object)e);
            return false;
        }
        if (!MessageDigest.isEqual(x5ts256.getBytes(), DERX509Base64UrlEncoded.getBytes())) {
            logger.warnf("certificate's thumbprint and one in the refresh token did not match.", new Object[0]);
            return false;
        }
        return true;
    }

    private static X509Certificate[] getCertificateChain(HttpRequest request, KeycloakSession session) {
        try {
            X509ClientCertificateLookup provider = (X509ClientCertificateLookup)session.getProvider(X509ClientCertificateLookup.class);
            if (provider == null) {
                logger.errorv("\"{0}\" Spi is not available, did you forget to update the configuration?", X509ClientCertificateLookup.class);
                return null;
            }
            X509Certificate[] certs = provider.getCertificateChain(request);
            return certs;
        }
        catch (GeneralSecurityException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private static String getCertificateThumbprintInSHA256DERX509Base64UrlEncoded(X509Certificate cert) throws NoSuchAlgorithmException, CertificateEncodingException {
        byte[] DERX509Hash = cert.getEncoded();
        MessageDigest md = MessageDigest.getInstance(DIGEST_ALG);
        md.update(DERX509Hash);
        String DERX509Base64UrlEncoded = Base64Url.encode((byte[])md.digest());
        return DERX509Base64UrlEncoded;
    }

    private static void dumpCertInfo(X509Certificate[] certs) throws CertificateEncodingException {
        logger.tracef(":: Try Holder of Key Token", new Object[0]);
        logger.tracef(":: # of x509 Client Certificate in Certificate Chain = %d", certs.length);
        for (int i = 0; i < certs.length; ++i) {
            logger.tracef(":: certs[%d] Raw Bytes Counts of first x509 Client Certificate in Certificate Chain = %d", i, certs[i].toString().length());
            logger.tracef(":: certs[%d] Raw Bytes String of first x509 Client Certificate in Certificate Chain = %s", i, (Object)certs[i].toString());
            logger.tracef(":: certs[%d] DER Dump Bytes of first x509 Client Certificate in Certificate Chain = %d", i, certs[i].getEncoded().length);
            String DERX509Base64UrlEncoded = null;
            try {
                DERX509Base64UrlEncoded = MtlsHoKTokenUtil.getCertificateThumbprintInSHA256DERX509Base64UrlEncoded(certs[i]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            logger.tracef(":: certs[%d] Base64URL Encoded SHA-256 Hash of DER formatted first x509 Client Certificate in Certificate Chain = %s", i, (Object)DERX509Base64UrlEncoded);
            logger.tracef(":: certs[%d] DER Dump Bytes of first x509 Client Certificate TBScertificate in Certificate Chain = %d", i, certs[i].getTBSCertificate().length);
            logger.tracef(":: certs[%d] Signature Algorithm of first x509 Client Certificate in Certificate Chain = %s", i, (Object)certs[i].getSigAlgName());
            logger.tracef(":: certs[%d] Certfication Type of first x509 Client Certificate in Certificate Chain = %s", i, (Object)certs[i].getType());
            logger.tracef(":: certs[%d] Issuer DN of first x509 Client Certificate in Certificate Chain = %s", i, (Object)certs[i].getIssuerDN().getName());
            logger.tracef(":: certs[%d] Subject DN of first x509 Client Certificate in Certificate Chain = %s", i, (Object)certs[i].getSubjectDN().getName());
        }
    }
}

