/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin.fgap;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.keycloak.authorization.fgap.AdminPermissionsSchema;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.ResourceWrapper;
import org.keycloak.authorization.model.Scope;
import org.keycloak.authorization.permission.ResourcePermission;
import org.keycloak.authorization.policy.evaluation.DecisionPermissionCollector;
import org.keycloak.authorization.policy.evaluation.EvaluationContext;
import org.keycloak.authorization.store.PolicyStore;
import org.keycloak.authorization.store.ResourceStore;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelIllegalStateException;
import org.keycloak.representations.idm.authorization.Permission;
import org.keycloak.services.resources.admin.fgap.MgmtPermissions;
import org.keycloak.services.resources.admin.fgap.ModelRecord;

class FineGrainedAdminPermissionEvaluator {
    private final KeycloakSession session;
    private final MgmtPermissions root;
    private final ResourceStore resourceStore;
    private final PolicyStore policyStore;

    FineGrainedAdminPermissionEvaluator(KeycloakSession session, MgmtPermissions root, ResourceStore resourceStore, PolicyStore policyStore) {
        this.session = session;
        this.root = root;
        this.resourceStore = resourceStore;
        this.policyStore = policyStore;
    }

    boolean hasPermission(ModelRecord model, EvaluationContext context, String scope) {
        return this.hasPermission(model.getId(), model.getResourceType(), context, scope);
    }

    boolean hasPermission(ModelRecord model, EvaluationContext context, String scope, Supplier<Boolean> defaultValue) {
        return this.hasPermission(model.getId(), model.getResourceType(), context, scope, defaultValue);
    }

    boolean hasPermission(String modelId, String resourceType, EvaluationContext context, String scope) {
        return this.hasPermission(modelId, resourceType, context, scope, null);
    }

    boolean hasPermission(String modelId, String resourceType, EvaluationContext context, String scopeName, Supplier<Boolean> defaultValue) {
        if (!this.root.isAdminSameRealm()) {
            return false;
        }
        ResourceServer server = this.root.realmResourceServer();
        if (server == null) {
            return false;
        }
        Resource resourceTypeResource = AdminPermissionsSchema.SCHEMA.getResourceTypeResource(this.session, server, resourceType);
        Resource resource = modelId == null ? resourceTypeResource : this.resourceStore.findByName(server, modelId);
        Scope scope = resourceTypeResource.getScopes().stream().filter(s -> s.getName().equals(scopeName)).findAny().orElseThrow(() -> new ModelIllegalStateException("Scope '%s' is not defined for resource type '%s'".formatted(scopeName, resourceType)));
        if (modelId != null && resource == null) {
            resource = new ResourceWrapper(modelId, modelId, Set.of(scope), server);
        }
        DecisionPermissionCollector decision = context == null ? this.root.getDecision(new ResourcePermission(resourceType, resource, (Collection)resource.getScopes(), server), server) : this.root.getDecision(new ResourcePermission(resourceType, resource, (Collection)resource.getScopes(), server), server, context);
        Collection permissions = decision.results();
        for (Permission permission : permissions) {
            if (!permission.getResourceId().equals(resource.getId()) || !permission.getScopes().contains(scopeName)) continue;
            return true;
        }
        if (defaultValue != null && !decision.isEvaluated(scopeName)) {
            return defaultValue.get();
        }
        return false;
    }

    Set<String> getIdsByScope(String resourceType, String scope) {
        if (!this.root.isAdminSameRealm()) {
            return Collections.emptySet();
        }
        ResourceServer server = this.root.realmResourceServer();
        if (server == null) {
            return Collections.emptySet();
        }
        return this.policyStore.findByResourceType(server, resourceType).stream().flatMap(policy -> policy.getResources().stream()).filter(resource -> this.hasPermission(resource.getName(), resourceType, null, scope)).map(Resource::getName).collect(Collectors.toSet());
    }
}

