/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientregistration.policy.impl;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.representations.idm.ProtocolMapperRepresentation;
import org.keycloak.services.ServicesLogger;
import org.keycloak.services.clientregistration.ClientRegistrationContext;
import org.keycloak.services.clientregistration.ClientRegistrationProvider;
import org.keycloak.services.clientregistration.policy.ClientRegistrationPolicy;
import org.keycloak.services.clientregistration.policy.ClientRegistrationPolicyException;

public class ProtocolMappersClientRegistrationPolicy
implements ClientRegistrationPolicy {
    private static final Logger logger = Logger.getLogger(ProtocolMappersClientRegistrationPolicy.class);
    private final KeycloakSession session;
    private final ComponentModel componentModel;

    public ProtocolMappersClientRegistrationPolicy(KeycloakSession session, ComponentModel componentModel) {
        this.session = session;
        this.componentModel = componentModel;
    }

    @Override
    public void beforeRegister(ClientRegistrationContext context) throws ClientRegistrationPolicyException {
        this.testMappers(context, null);
    }

    protected void testMappers(ClientRegistrationContext context, ClientModel clientModel) throws ClientRegistrationPolicyException {
        List protocolMappers = context.getClient().getProtocolMappers();
        if (protocolMappers == null) {
            return;
        }
        List<String> allowedMapperProviders = this.getAllowedMapperProviders();
        for (ProtocolMapperRepresentation mapperRepresentation : protocolMappers) {
            String mapperType = mapperRepresentation.getProtocolMapper();
            if (allowedMapperProviders.contains(mapperType)) continue;
            if (clientModel == null) {
                this.failWithProtocolMapperTypeNotAllowedError(mapperRepresentation);
                return;
            }
            String mapperRepresentationId = mapperRepresentation.getId();
            if (mapperRepresentationId == null) {
                String message = "Missing id for mapper named '%s'".formatted(mapperRepresentation.getName());
                ServicesLogger.LOGGER.warn(message);
                throw new ClientRegistrationPolicyException(message);
            }
            ProtocolMapperModel mapperModel = clientModel.getProtocolMapperById(mapperRepresentationId);
            if (mapperModel == null) {
                String message = "No existing mapper model found for id '%s'".formatted(mapperRepresentationId);
                ServicesLogger.LOGGER.warn(message);
                throw new ClientRegistrationPolicyException(message);
            }
            Map modelConfig = mapperModel.getConfig();
            Map representationConfig = mapperRepresentation.getConfig();
            if (Objects.equals(representationConfig, modelConfig)) continue;
            this.failWithProtocolMapperTypeNotAllowedError(mapperRepresentation);
            return;
        }
    }

    protected void failWithProtocolMapperTypeNotAllowedError(ProtocolMapperRepresentation mapper) {
        ServicesLogger.LOGGER.clientRegistrationMapperNotAllowed(mapper.getName(), mapper.getProtocolMapper());
        throw new ClientRegistrationPolicyException("ProtocolMapper type not allowed");
    }

    @Override
    public void afterRegister(ClientRegistrationContext context, ClientModel clientModel) {
        List<String> allowedMapperProviders = this.getAllowedMapperProviders();
        clientModel.getProtocolMappersStream().filter(mapper -> !allowedMapperProviders.contains(mapper.getProtocolMapper())).peek(mapperToRemove -> logger.debugf("Removing builtin mapper '%s' of type '%s' as type is not permitted", (Object)mapperToRemove.getName(), (Object)mapperToRemove.getProtocolMapper())).collect(Collectors.toList()).forEach(arg_0 -> ((ClientModel)clientModel).removeProtocolMapper(arg_0));
    }

    @Override
    public void beforeUpdate(ClientRegistrationContext context, ClientModel clientModel) throws ClientRegistrationPolicyException {
        this.testMappers(context, clientModel);
    }

    @Override
    public void afterUpdate(ClientRegistrationContext context, ClientModel clientModel) {
    }

    @Override
    public void beforeView(ClientRegistrationProvider provider, ClientModel clientModel) throws ClientRegistrationPolicyException {
    }

    @Override
    public void beforeDelete(ClientRegistrationProvider provider, ClientModel clientModel) throws ClientRegistrationPolicyException {
    }

    private List<String> getAllowedMapperProviders() {
        return this.componentModel.getConfig().getList((Object)"allowed-protocol-mapper-types");
    }
}

