/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientregistration.policy.impl;

import java.util.LinkedList;
import java.util.List;
import org.keycloak.component.ComponentModel;
import org.keycloak.component.ComponentValidationException;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.provider.ConfigurationValidationHelper;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.services.clientregistration.policy.AbstractClientRegistrationPolicyFactory;
import org.keycloak.services.clientregistration.policy.ClientRegistrationPolicy;
import org.keycloak.services.clientregistration.policy.impl.MaxClientsClientRegistrationPolicy;

public class MaxClientsClientRegistrationPolicyFactory
extends AbstractClientRegistrationPolicyFactory {
    public static final String MAX_CLIENTS = "max-clients";
    public static final ProviderConfigProperty MAX_CLIENTS_PROPERTY = new ProviderConfigProperty();
    public static final int DEFAULT_MAX_CLIENTS = 200;
    private static List<ProviderConfigProperty> configProperties = new LinkedList<ProviderConfigProperty>();
    public static final String PROVIDER_ID = "max-clients";

    public ClientRegistrationPolicy create(KeycloakSession session, ComponentModel model) {
        return new MaxClientsClientRegistrationPolicy(session, model);
    }

    public String getHelpText() {
        return "When present, then it won't be allowed to register new client if count of existing clients in realm is same or bigger than configured limit";
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return configProperties;
    }

    public String getId() {
        return "max-clients";
    }

    @Override
    public void validateConfiguration(KeycloakSession session, RealmModel realm, ComponentModel config) throws ComponentValidationException {
        ConfigurationValidationHelper.check((ComponentModel)config).checkInt(MAX_CLIENTS_PROPERTY, true);
    }

    static {
        MAX_CLIENTS_PROPERTY.setName("max-clients");
        MAX_CLIENTS_PROPERTY.setLabel("max-clients.label");
        MAX_CLIENTS_PROPERTY.setHelpText("max-clients.tooltip");
        MAX_CLIENTS_PROPERTY.setType("String");
        MAX_CLIENTS_PROPERTY.setDefaultValue((Object)String.valueOf(200));
        configProperties.add(MAX_CLIENTS_PROPERTY);
    }
}

