/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientpolicy.executor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.keycloak.Config;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.services.clientpolicy.executor.ClientPolicyExecutorProvider;
import org.keycloak.services.clientpolicy.executor.ClientPolicyExecutorProviderFactory;
import org.keycloak.services.clientpolicy.executor.SecureRequestObjectExecutor;

public class SecureRequestObjectExecutorFactory
implements ClientPolicyExecutorProviderFactory {
    public static final String PROVIDER_ID = "secure-request-object";
    public static final String VERIFY_NBF = "verify-nbf";
    private static final ProviderConfigProperty VERIFY_NBF_PROPERTY = new ProviderConfigProperty("verify-nbf", "Verify Not-Before", "If ON, then it will be verified if 'request' object used in OIDC authorization request contains not-before claim and this claim will be validated", "boolean", (Object)true);
    public static final String AVAILABLE_PERIOD = "available-period";
    private static final ProviderConfigProperty AVAILABLE_PERIOD_PROPERTY = new ProviderConfigProperty("available-period", "Available Period", "The maximum period in seconds for which the 'request' object used in OIDC authorization request is considered valid. It is used if 'Verify Not-Before' is ON.", "String", (Object)"3600");
    public static final String ENCRYPTION_REQUIRED = "encryption-required";
    private static final ProviderConfigProperty ENCRYPTION_REQUIRED_PROPERTY = new ProviderConfigProperty("encryption-required", "Encryption Required", "Whether request object encryption is required. If enabled, request objects must be encrypted. Otherwise, encryption is optional.", "boolean", (Object)Boolean.FALSE);
    public static final String ALLOWED_CLOCK_SKEW = "allowed-clock-skew";
    private static final ProviderConfigProperty ALLOWED_CLOCK_SKEW_PROPERTY = new ProviderConfigProperty("allowed-clock-skew", "Allowed Clock Skew", "The allowed clock skew (sec) between a client and Keycloak. For example, if nbf claim values of 'request' object is ahead from Keycloak's clock within the clock skew, Keycloak accept the object even if its nbf claim value indicates the future.", "String", (Object)"15");

    public ClientPolicyExecutorProvider create(KeycloakSession session) {
        return new SecureRequestObjectExecutor(session);
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public String getHelpText() {
        return "The executor checks whether the client treats the request object in its authorization request by following Financial-grade API Security Profile : Read and Write API Security Profile.";
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return new ArrayList<ProviderConfigProperty>(Arrays.asList(VERIFY_NBF_PROPERTY, AVAILABLE_PERIOD_PROPERTY, ENCRYPTION_REQUIRED_PROPERTY, ALLOWED_CLOCK_SKEW_PROPERTY));
    }
}

