/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.grants.ciba;

import org.keycloak.common.enums.SslRequired;
import org.keycloak.common.util.UriUtils;
import org.keycloak.crypto.SignatureProvider;
import org.keycloak.jose.jws.Algorithm;
import org.keycloak.models.CibaConfig;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.validation.ValidationContext;

public class CibaClientValidation {
    private final ValidationContext<ClientModel> context;

    public CibaClientValidation(ValidationContext<ClientModel> context) {
        this.context = context;
    }

    public void validate() {
        ClientModel client = (ClientModel)this.context.getObjectToValidate();
        CibaConfig cibaConfig = client.getRealm().getCibaPolicy();
        String cibaMode = cibaConfig.getBackchannelTokenDeliveryMode(client);
        if (!CibaConfig.CIBA_SUPPORTED_MODES.contains(cibaMode)) {
            this.context.addError("cibaBackchannelTokenDeliveryMode", "Unsupported requested CIBA Backchannel Token Delivery Mode", "invalidCibaBackchannelTokenDeliveryMode", new Object[0]);
        }
        if ("ping".equals(cibaMode) && cibaConfig.getBackchannelClientNotificationEndpoint(client) == null) {
            this.context.addError("cibaBackchannelClientNotificationEndpoint", "CIBA Backchannel Client Notification Endpoint must be set for the CIBA ping mode", "missingCibaBackchannelClientNotificationEndpoint", new Object[0]);
        }
        try {
            UriUtils.checkUrl((SslRequired)client.getRealm().getSslRequired(), (String)cibaConfig.getBackchannelClientNotificationEndpoint(client), (String)"backchannel_client_notification_endpoint");
        }
        catch (RuntimeException re) {
            this.context.addError("cibaBackchannelClientNotificationEndpoint", re.getMessage(), "invalidBackchannelClientNotificationEndpoint", new Object[0]);
        }
        Algorithm alg = cibaConfig.getBackchannelAuthRequestSigningAlg(client);
        if (alg != null && !CibaClientValidation.isSupportedBackchannelAuthenticationRequestSigningAlg(this.context.getSession(), alg.name())) {
            this.context.addError("cibaBackchannelAuthRequestSigningAlg", "Unsupported requested CIBA Backchannel Authentication Request Signing Algorithm", "invalidCibaBackchannelAuthRequestSigningAlg", new Object[0]);
        }
    }

    private static boolean isSupportedBackchannelAuthenticationRequestSigningAlg(KeycloakSession session, String alg) {
        if (Algorithm.none.name().equals(alg)) {
            return true;
        }
        SignatureProvider signatureProvider = (SignatureProvider)session.getProvider(SignatureProvider.class, alg);
        return signatureProvider.isAsymmetricAlgorithm();
    }
}

