/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.workflow;

import java.util.List;
import java.util.Map;
import org.jboss.logging.Logger;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.workflow.WorkflowStepProvider;

public class SetUserAttributeStepProvider
implements WorkflowStepProvider {
    private final KeycloakSession session;
    private final ComponentModel stepModel;
    private final Logger log = Logger.getLogger(SetUserAttributeStepProvider.class);

    public SetUserAttributeStepProvider(KeycloakSession session, ComponentModel model) {
        this.session = session;
        this.stepModel = model;
    }

    public void close() {
    }

    public void run(List<String> userIds) {
        RealmModel realm = this.session.getContext().getRealm();
        for (String id : userIds) {
            UserModel user = this.session.users().getUserById(realm, id);
            if (user == null) continue;
            for (Map.Entry entry : this.stepModel.getConfig().entrySet()) {
                String key = (String)entry.getKey();
                if (key.startsWith("after") || key.startsWith("priority")) continue;
                this.log.debugv("Setting attribute {0} to user {1})", (Object)key, (Object)user.getId());
                user.setAttribute(key, (List)entry.getValue());
            }
        }
    }
}

