/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.workflow;

import java.util.List;
import org.jboss.logging.Logger;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.workflow.WorkflowStepProvider;

public class DisableUserStepProvider
implements WorkflowStepProvider {
    private final KeycloakSession session;
    private final Logger log = Logger.getLogger(DisableUserStepProvider.class);

    public DisableUserStepProvider(KeycloakSession session, ComponentModel model) {
        this.session = session;
    }

    public void close() {
    }

    public void run(List<String> userIds) {
        RealmModel realm = this.session.getContext().getRealm();
        for (String id : userIds) {
            UserModel user = this.session.users().getUserById(realm, id);
            if (user == null || !user.isEnabled()) continue;
            this.log.debugv("Disabling user {0} ({1})", (Object)user.getUsername(), (Object)user.getId());
            user.setEnabled(false);
        }
    }
}

