/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.keys;

import java.util.List;
import org.keycloak.component.ComponentModel;
import org.keycloak.crypto.KeyUse;
import org.keycloak.keys.AbstractImportedRsaKeyProviderFactory;
import org.keycloak.keys.Attributes;
import org.keycloak.keys.ImportedRsaKeyProvider;
import org.keycloak.keys.KeyProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.provider.ProviderConfigProperty;

public class ImportedRsaKeyProviderFactory
extends AbstractImportedRsaKeyProviderFactory {
    public static final String ID = "rsa";
    private static final String HELP_TEXT = "RSA signature key provider that can optionally generated a self-signed certificate";
    private static final List<ProviderConfigProperty> CONFIG_PROPERTIES = AbstractImportedRsaKeyProviderFactory.rsaKeyConfigurationBuilder().property(Attributes.RS_ALGORITHM_PROPERTY).build();

    public KeyProvider create(KeycloakSession session, ComponentModel model) {
        if (model.getConfig().get((Object)"keyUse") == null) {
            model.put("keyUse", KeyUse.SIG.name());
        }
        return new ImportedRsaKeyProvider(session.getContext().getRealm(), model);
    }

    public String getHelpText() {
        return HELP_TEXT;
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return CONFIG_PROPERTIES;
    }

    @Override
    protected boolean isValidKeyUse(KeyUse keyUse) {
        return keyUse.equals((Object)KeyUse.SIG);
    }

    @Override
    protected boolean isSupportedRsaAlgorithm(String algorithm) {
        return algorithm.equals("RS256") || algorithm.equals("PS256") || algorithm.equals("RS384") || algorithm.equals("PS384") || algorithm.equals("RS512") || algorithm.equals("PS512");
    }

    public String getId() {
        return ID;
    }
}

