/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.keys;

import java.util.List;
import org.jboss.logging.Logger;
import org.keycloak.component.ComponentModel;
import org.keycloak.crypto.KeyUse;
import org.keycloak.keys.AbstractGeneratedRsaKeyProviderFactory;
import org.keycloak.keys.AbstractRsaKeyProvider;
import org.keycloak.keys.Attributes;
import org.keycloak.keys.KeyProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.provider.ProviderConfigProperty;

public class GeneratedRsaKeyProviderFactory
extends AbstractGeneratedRsaKeyProviderFactory {
    private static final Logger logger = Logger.getLogger(GeneratedRsaKeyProviderFactory.class);
    public static final String ID = "rsa-generated";
    private static final String HELP_TEXT = "Generates RSA signature keys and creates a self-signed certificate";

    public KeyProvider create(KeycloakSession session, ComponentModel model) {
        if (model.getConfig().get((Object)"keyUse") == null) {
            model.put("keyUse", KeyUse.SIG.name());
        }
        return new AbstractRsaKeyProvider(session.getContext().getRealm(), model){};
    }

    public String getHelpText() {
        return HELP_TEXT;
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return this.generatedRsaKeyConfigurationBuilder().property(Attributes.RS_ALGORITHM_PROPERTY).build();
    }

    public String getId() {
        return ID;
    }

    @Override
    protected boolean isValidKeyUse(KeyUse keyUse) {
        return keyUse.equals((Object)KeyUse.SIG);
    }

    @Override
    protected boolean isSupportedRsaAlgorithm(String algorithm) {
        return algorithm.equals("RS256") || algorithm.equals("PS256") || algorithm.equals("RS384") || algorithm.equals("PS384") || algorithm.equals("RS512") || algorithm.equals("PS512");
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }
}

