/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.forms;

import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.jboss.logging.Logger;
import org.keycloak.authentication.ValidationContext;
import org.keycloak.authentication.forms.AbstractRegistrationRecaptcha;
import org.keycloak.connections.httpclient.HttpClientProvider;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderConfigurationBuilder;
import org.keycloak.services.ServicesLogger;
import org.keycloak.util.JsonSerialization;
import org.keycloak.utils.StringUtil;

public class RegistrationRecaptcha
extends AbstractRegistrationRecaptcha {
    private static final Logger LOGGER = Logger.getLogger(RegistrationRecaptcha.class);
    public static final String PROVIDER_ID = "registration-recaptcha-action";
    public static final String SECRET_KEY = "secret.key";
    public static final String OLD_SECRET = "secret";

    public String getDisplayType() {
        return "reCAPTCHA";
    }

    public String getHelpText() {
        return "Adds Google reCAPTCHA to the form.";
    }

    @Override
    public AuthenticationExecutionModel.Requirement[] getRequirementChoices() {
        return new AuthenticationExecutionModel.Requirement[]{AuthenticationExecutionModel.Requirement.REQUIRED, AuthenticationExecutionModel.Requirement.DISABLED};
    }

    @Override
    protected boolean validateConfig(Map<String, String> config) {
        return !StringUtil.isNullOrEmpty((String)config.get("site.key")) && (!StringUtil.isNullOrEmpty((String)config.get(SECRET_KEY)) || !StringUtil.isNullOrEmpty((String)config.get(OLD_SECRET)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean validate(ValidationContext context, String captcha, Map<String, String> config) {
        LOGGER.trace((Object)"Verifying reCAPTCHA using non-enterprise API");
        CloseableHttpClient httpClient = ((HttpClientProvider)context.getSession().getProvider(HttpClientProvider.class)).getHttpClient();
        HttpPost post = new HttpPost("https://www." + this.getRecaptchaDomain(config) + "/recaptcha/api/siteverify");
        LinkedList<BasicNameValuePair> formparams = new LinkedList<BasicNameValuePair>();
        String secret = config.get(SECRET_KEY);
        if (StringUtil.isNullOrEmpty((String)secret) && !StringUtil.isNullOrEmpty((String)(secret = config.get(OLD_SECRET)))) {
            config.put(SECRET_KEY, secret);
            config.remove(OLD_SECRET);
        }
        formparams.add(new BasicNameValuePair(OLD_SECRET, secret));
        formparams.add(new BasicNameValuePair("response", captcha));
        if (context.getConnection().getRemoteAddr() != null) {
            formparams.add(new BasicNameValuePair("remoteip", context.getConnection().getRemoteAddr()));
        }
        try {
            UrlEncodedFormEntity form = new UrlEncodedFormEntity(formparams, StandardCharsets.UTF_8);
            post.setEntity((HttpEntity)form);
            try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)post);){
                boolean bl;
                InputStream content = response.getEntity().getContent();
                try {
                    Map json = (Map)JsonSerialization.readValue((InputStream)content, Map.class);
                    bl = Boolean.TRUE.equals(json.get("success"));
                }
                catch (Throwable throwable) {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                    throw throwable;
                }
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                return bl;
            }
        }
        catch (Exception e) {
            ServicesLogger.LOGGER.recaptchaFailed(e);
            return false;
        }
    }

    @Override
    protected String getScriptUrl(Map<String, String> config, String userLanguageTag) {
        return "https://www." + this.getRecaptchaDomain(config) + "/recaptcha/api.js?hl=" + userLanguageTag;
    }

    public String getId() {
        return PROVIDER_ID;
    }

    @Override
    public List<ProviderConfigProperty> getConfigProperties() {
        List properties = ProviderConfigurationBuilder.create().property().name("site.key").label("reCAPTCHA Site Key").helpText("The site key.").type("String").add().property().name(SECRET_KEY).label("reCAPTCHA Secret").helpText("The secret key.").type("String").secret(true).add().build();
        properties.addAll(super.getConfigProperties());
        return properties;
    }
}

