/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.actiontoken.execactions;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.LinkedList;
import java.util.List;
import org.keycloak.authentication.actiontoken.DefaultActionToken;

public class ExecuteActionsActionToken
extends DefaultActionToken {
    public static final String TOKEN_TYPE = "execute-actions";
    private static final String JSON_FIELD_REQUIRED_ACTIONS = "rqac";
    private static final String JSON_FIELD_REDIRECT_URI = "reduri";
    @JsonProperty(value="rqac")
    private List<String> requiredActions;
    @JsonProperty(value="reduri")
    private String redirectUri;

    public ExecuteActionsActionToken(String userId, int absoluteExpirationInSecs, List<String> requiredActions, String redirectUri, String clientId) {
        super(userId, TOKEN_TYPE, absoluteExpirationInSecs, null);
        this.setRequiredActions(requiredActions == null ? new LinkedList<String>() : new LinkedList<String>(requiredActions));
        this.setRedirectUri(redirectUri);
        this.issuedFor = clientId;
    }

    public ExecuteActionsActionToken(String userId, String email, int absoluteExpirationInSecs, List<String> requiredActions, String redirectUri, String clientId) {
        this(userId, absoluteExpirationInSecs, requiredActions, redirectUri, clientId);
        this.setEmail(email);
    }

    private ExecuteActionsActionToken() {
    }

    public List<String> getRequiredActions() {
        return this.requiredActions;
    }

    public void setRequiredActions(List<String> requiredActions) {
        this.requiredActions = requiredActions;
    }

    public String getRedirectUri() {
        return this.redirectUri;
    }

    public void setRedirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
    }
}

