/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.representations.idm;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.keycloak.json.StringListMapDeserializer;
import org.keycloak.representations.idm.UserProfileMetadata;

public abstract class AbstractUserRepresentation {
    public static String USERNAME = "username";
    public static String FIRST_NAME = "firstName";
    public static String LAST_NAME = "lastName";
    public static String EMAIL = "email";
    public static String LOCALE = "locale";
    protected String id;
    protected String username;
    protected String firstName;
    protected String lastName;
    protected String email;
    protected Boolean emailVerified;
    @JsonDeserialize(using=StringListMapDeserializer.class)
    protected Map<String, List<String>> attributes;
    private UserProfileMetadata userProfileMetadata;
    protected Boolean enabled;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public Boolean isEmailVerified() {
        return this.emailVerified;
    }

    public void setEmailVerified(Boolean emailVerified) {
        this.emailVerified = emailVerified;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public Map<String, List<String>> getAttributes() {
        return this.attributes;
    }

    @JsonIgnore
    public Map<String, List<String>> getRawAttributes() {
        HashMap<String, List<String>> attrs = new HashMap<String, List<String>>(Optional.ofNullable(this.attributes).orElse(new HashMap()));
        if (this.username != null) {
            attrs.put(USERNAME, Collections.singletonList(this.getUsername()));
        } else {
            attrs.remove(USERNAME);
        }
        if (this.email != null) {
            attrs.put(EMAIL, Collections.singletonList(this.getEmail()));
        } else {
            attrs.remove(EMAIL);
        }
        if (this.lastName != null) {
            attrs.put(LAST_NAME, Collections.singletonList(this.getLastName()));
        }
        if (this.firstName != null) {
            attrs.put(FIRST_NAME, Collections.singletonList(this.getFirstName()));
        }
        return attrs;
    }

    public void setAttributes(Map<String, List<String>> attributes) {
        this.attributes = attributes;
    }

    public <R extends AbstractUserRepresentation> R singleAttribute(String name, String value) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, List<String>>();
        }
        this.attributes.put(name, value == null ? Collections.emptyList() : Arrays.asList(value));
        return (R)this;
    }

    public String firstAttribute(String key) {
        return this.attributes == null ? null : (this.attributes.get(key) == null ? null : (this.attributes.get(key).isEmpty() ? null : this.attributes.get(key).get(0)));
    }

    public void setUserProfileMetadata(UserProfileMetadata userProfileMetadata) {
        this.userProfileMetadata = userProfileMetadata;
    }

    public UserProfileMetadata getUserProfileMetadata() {
        return this.userProfileMetadata;
    }

    public Boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }
}

