/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.client.admin.cli.commands;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.keycloak.client.admin.cli.KcAdmMain;
import org.keycloak.client.admin.cli.commands.GetCmd;
import org.keycloak.client.admin.cli.operations.ClientOperations;
import org.keycloak.client.admin.cli.operations.GroupOperations;
import org.keycloak.client.admin.cli.operations.RoleOperations;
import org.keycloak.client.admin.cli.operations.UserOperations;
import org.keycloak.client.cli.config.ConfigData;
import org.keycloak.client.cli.util.ConfigUtil;
import org.keycloak.client.cli.util.HttpUtil;
import org.keycloak.client.cli.util.OsUtil;
import picocli.CommandLine;

@CommandLine.Command(name="get-roles", description={"[ARGUMENTS]"})
public class GetRolesCmd
extends GetCmd {
    @CommandLine.Option(names={"--uusername"}, description={"Target user's 'username'"})
    String uusername;
    @CommandLine.Option(names={"--uid"}, description={"Target user's 'id'"})
    String uid;
    @CommandLine.Option(names={"--cclientid"}, description={"Target client's 'clientId'"})
    String cclientid;
    @CommandLine.Option(names={"--cid"}, description={"Target client's 'id'"})
    String cid;
    @CommandLine.Option(names={"--rname"}, description={"Composite role's 'name'"})
    String rname;
    @CommandLine.Option(names={"--rid"}, description={"Composite role's 'id'"})
    String rid;
    @CommandLine.Option(names={"--gname"}, description={"Target group's 'name'"})
    String gname;
    @CommandLine.Option(names={"--gpath"}, description={"Target group's 'path'"})
    String gpath;
    @CommandLine.Option(names={"--gid"}, description={"Target group's 'id'"})
    String gid;
    @CommandLine.Option(names={"--rolename"}, description={"Target role's 'name'"})
    String rolename;
    @CommandLine.Option(names={"--roleid"}, description={"Target role's 'id'"})
    String roleid;
    @CommandLine.Option(names={"--available"}, description={"List only available roles"})
    boolean available;
    @CommandLine.Option(names={"--effective"}, description={"List assigned roles including transitively included roles"})
    boolean effective;
    @CommandLine.Option(names={"--all"}, description={"List roles for all clients in addition to realm roles"})
    boolean all;

    @Override
    protected void processOptions() {
        if (this.uri == null) {
            this.uri = "uri";
        }
        if (this.uid != null && this.uusername != null) {
            throw new IllegalArgumentException("Incompatible options: --uid and --uusername are mutually exclusive");
        }
        if (this.gid != null && this.gname != null || this.gid != null && this.gpath != null || this.gname != null && this.gpath != null) {
            throw new IllegalArgumentException("Incompatible options: --gid, --gname and --gpath are mutually exclusive");
        }
        if (this.roleid != null && this.rolename != null) {
            throw new IllegalArgumentException("Incompatible options: --roleid and --rolename are mutually exclusive");
        }
        if (this.rid != null && this.rname != null) {
            throw new IllegalArgumentException("Incompatible options: --rid and --rname are mutually exclusive");
        }
        if (this.cid != null && this.cclientid != null) {
            throw new IllegalArgumentException("Incompatible options: --cid and --cclientid are mutually exclusive");
        }
        if (this.isUserSpecified() && this.isGroupSpecified()) {
            throw new IllegalArgumentException("Incompatible options: --uusername / --uid can't be used at the same time as --gname / --gid / --gpath");
        }
        if (this.isUserSpecified() && this.isCompositeRoleSpecified()) {
            throw new IllegalArgumentException("Incompatible options: --uusername / --uid can't be used at the same time as --rname / --rid");
        }
        if (this.isGroupSpecified() && this.isCompositeRoleSpecified()) {
            throw new IllegalArgumentException("Incompatible options: --rname / --rid can't be used at the same time as --gname / --gid / --gpath");
        }
        if (this.all && this.effective) {
            throw new IllegalArgumentException("Incompatible options: --all can't be used at the same time as --effective");
        }
        if (this.all && this.available) {
            throw new IllegalArgumentException("Incompatible options: --all can't be used at the same time as --available");
        }
        super.processOptions();
    }

    @Override
    protected void process() {
        String adminRoot;
        ConfigData config = ConfigUtil.loadConfig();
        config = this.copyWithServerInfo(config);
        this.setupTruststore(config);
        Object auth = null;
        config = this.ensureAuthInfo(config);
        config = this.copyWithServerInfo(config);
        if (ConfigUtil.credentialsAvailable(config)) {
            auth = this.ensureToken(config);
        }
        auth = auth != null ? "Bearer " + (String)auth : null;
        String server = config.getServerUrl();
        String realm = this.getTargetRealm(config);
        String string = adminRoot = this.adminRestRoot != null ? this.adminRestRoot : this.composeAdminRoot(server);
        if (this.isUserSpecified()) {
            if (this.uid == null) {
                this.uid = UserOperations.getIdFromUsername(adminRoot, realm, (String)auth, this.uusername);
            }
            if (this.isClientSpecified()) {
                if (this.cid == null) {
                    this.cid = ClientOperations.getIdFromClientId(adminRoot, realm, (String)auth, this.cclientid);
                }
                this.uri = this.available ? HttpUtil.composeResourceUrl(adminRoot, realm, "users/" + this.uid + "/role-mappings/clients/" + this.cid + "/available") : (this.effective ? HttpUtil.composeResourceUrl(adminRoot, realm, "users/" + this.uid + "/role-mappings/clients/" + this.cid + "/composite") : HttpUtil.composeResourceUrl(adminRoot, realm, "users/" + this.uid + "/role-mappings/clients/" + this.cid));
            } else {
                this.uri = this.available ? HttpUtil.composeResourceUrl(adminRoot, realm, "users/" + this.uid + "/role-mappings/realm/available") : (this.effective ? HttpUtil.composeResourceUrl(adminRoot, realm, "users/" + this.uid + "/role-mappings/realm/composite") : HttpUtil.composeResourceUrl(adminRoot, realm, "users/" + this.uid + (this.all ? "/role-mappings" : "/role-mappings/realm")));
            }
        } else if (this.isGroupSpecified()) {
            if (this.gname != null) {
                this.gid = GroupOperations.getIdFromName(adminRoot, realm, (String)auth, this.gname);
            } else if (this.gpath != null) {
                this.gid = GroupOperations.getIdFromPath(adminRoot, realm, (String)auth, this.gpath);
            }
            if (this.isClientSpecified()) {
                if (this.cid == null) {
                    this.cid = ClientOperations.getIdFromClientId(adminRoot, realm, (String)auth, this.cclientid);
                }
                this.uri = this.available ? HttpUtil.composeResourceUrl(adminRoot, realm, "groups/" + this.gid + "/role-mappings/clients/" + this.cid + "/available") : (this.effective ? HttpUtil.composeResourceUrl(adminRoot, realm, "groups/" + this.gid + "/role-mappings/clients/" + this.cid + "/composite") : HttpUtil.composeResourceUrl(adminRoot, realm, "groups/" + this.gid + "/role-mappings/clients/" + this.cid));
            } else {
                this.uri = this.available ? HttpUtil.composeResourceUrl(adminRoot, realm, "groups/" + this.gid + "/role-mappings/realm/available") : (this.effective ? HttpUtil.composeResourceUrl(adminRoot, realm, "groups/" + this.gid + "/role-mappings/realm/composite") : HttpUtil.composeResourceUrl(adminRoot, realm, "groups/" + this.gid + (this.all ? "/role-mappings" : "/role-mappings/realm")));
            }
        } else if (this.isCompositeRoleSpecified()) {
            String uri;
            String string2 = uri = this.rname != null ? "roles/" + this.rname : "roles-by-id/" + this.rid;
            if (this.isClientSpecified()) {
                if (this.cid == null) {
                    this.cid = ClientOperations.getIdFromClientId(adminRoot, realm, (String)auth, this.cclientid);
                }
                if (this.available) {
                    throw new IllegalArgumentException("Option --available not supported with composite roles. Try '" + KcAdmMain.CMD + " get-roles --cid " + this.cid + "' for full list of client roles for that client");
                }
                if (this.effective) {
                    throw new IllegalArgumentException("Option --effective not supported with composite roles.");
                }
                uri = uri + "/composites/clients/" + this.cid;
            } else {
                if (this.available) {
                    throw new IllegalArgumentException("Option --available not supported with composite roles. Try '" + KcAdmMain.CMD + " get-roles' for full list of realm roles");
                }
                if (this.effective) {
                    throw new IllegalArgumentException("Option --effective not supported with composite roles.");
                }
                uri = uri + (this.all ? "/composites" : "/composites/realm");
            }
            this.uri = HttpUtil.composeResourceUrl(adminRoot, realm, uri);
        } else if (this.isClientSpecified()) {
            if (this.cid == null) {
                this.cid = ClientOperations.getIdFromClientId(adminRoot, realm, (String)auth, this.cclientid);
            }
            if (this.isRoleSpecified()) {
                if (this.rolename == null) {
                    this.rolename = RoleOperations.getClientRoleNameFromId(adminRoot, realm, (String)auth, this.cid, this.roleid);
                }
                this.uri = HttpUtil.composeResourceUrl(adminRoot, realm, "clients/" + this.cid + "/roles/" + this.rolename);
            } else {
                this.uri = HttpUtil.composeResourceUrl(adminRoot, realm, "clients/" + this.cid + "/roles");
            }
        } else if (this.isRoleSpecified()) {
            if (this.rolename == null) {
                this.rolename = RoleOperations.getClientRoleNameFromId(adminRoot, realm, (String)auth, this.cid, this.roleid);
            }
            this.uri = HttpUtil.composeResourceUrl(adminRoot, realm, "roles/" + this.rolename);
        } else {
            this.uri = HttpUtil.composeResourceUrl(adminRoot, realm, "roles");
        }
        super.process();
    }

    private boolean isRoleSpecified() {
        return this.roleid != null || this.rolename != null;
    }

    private boolean isClientSpecified() {
        return this.cid != null || this.cclientid != null;
    }

    private boolean isGroupSpecified() {
        return this.gid != null || this.gname != null || this.gpath != null;
    }

    private boolean isCompositeRoleSpecified() {
        return this.rid != null || this.rname != null;
    }

    private boolean isUserSpecified() {
        return this.uid != null || this.uusername != null;
    }

    @Override
    protected boolean nothingToDo() {
        return false;
    }

    @Override
    protected String help() {
        StringWriter sb = new StringWriter();
        PrintWriter out = new PrintWriter(sb);
        out.println("Usage: " + KcAdmMain.CMD + " get-roles [--cclientid CLIENT_ID | --cid ID] [ARGUMENTS]");
        out.println("       " + KcAdmMain.CMD + " get-roles (--uusername USERNAME | --uid ID) [--cclientid CLIENT_ID | --cid ID] [--available | --effective | --all] (ARGUMENTS)");
        out.println("       " + KcAdmMain.CMD + " get-roles (--gname NAME | --gpath PATH | --gid ID) [--cclientid CLIENT_ID | --cid ID] [--available | --effective | --all] [ARGUMENTS]");
        out.println("       " + KcAdmMain.CMD + " get-roles (--rname ROLE_NAME | --rid ROLE_ID) [--cclientid CLIENT_ID | --cid ID] [--available | --effective | --all] [ARGUMENTS]");
        out.println();
        out.println("Command to list realm or client roles of a realm, a user, a group or a composite role.");
        out.println();
        out.println("Use '" + KcAdmMain.CMD + " config credentials' to establish an authenticated session, or use CREDENTIALS OPTIONS");
        out.println("to perform one time authentication.");
        out.println();
        out.println("If client is specified using --cclientid or --cid then client roles are listed, otherwise realm roles are listed.");
        out.println("If user is specified using --uusername or --uid then roles are listed for a specific user.");
        out.println("If group is specified using --gname, --gpath or --gid then roles are listed for a specific group.");
        out.println("If composite role is specified --rname or --rid then roles are listed for a specific composite role.");
        out.println("If neither user nor group, nor composite role is specified then defined roles are listed for a realm or specific client.");
        out.println("If role is specified using --rolename or --roleid then only that specific role is returned.");
        out.println("If --available is specified, then only roles not yet added to the target user or group are returned.");
        out.println("If --effective is specified, then roles added to the target user or group are transitively resolved and a full");
        out.println("set of roles in effect for that user, group or composite role is returned.");
        out.println("If --all is specified, then client roles for all clients are returned in addition to realm roles.");
        this.globalOptions(out);
        out.println("    --uusername               User's 'username'. If more than one user exists with the same username");
        out.println("                              you'll have to use --uid to specify the target user");
        out.println("    --uid                     User's 'id' attribute");
        out.println("    --gname                   Group's 'name'. If more than one group exists with the same name you'll have");
        out.println("                              to use --gid, or --gpath to specify the target group");
        out.println("    --gpath                   Group's 'path' attribute");
        out.println("    --gid                     Group's 'id' attribute");
        out.println("    --rname                   Composite role's 'name' attribute");
        out.println("    --rid                     Composite role's 'id' attribute");
        out.println("    --cclientid               Client's 'clientId' attribute");
        out.println("    --cid                     Client's 'id' attribute");
        out.println("    --rolename                Role's 'name' attribute");
        out.println("    --roleid                  Role's 'id' attribute");
        out.println("    --available               Return available roles - those that can still be added");
        out.println("    --effective               Return effective roles - transitively taking composite roles into account");
        out.println("    --all                     Return all client roles in addition to realm roles");
        out.println();
        out.println("    -H, --print-headers       Print response headers");
        out.println("    -F, --fields FILTER       A filter pattern to specify which fields of a JSON response to output");
        out.println("                              Use '" + KcAdmMain.CMD + " get --help' for more info on FILTER syntax.");
        out.println("    -c, --compressed          Don't pretty print the output");
        out.println("    --format FORMAT           Set output format to comma-separated-values by using 'csv'. Default format is 'json'");
        out.println("    --noquotes                Don't quote strings when output format is 'csv'");
        out.println("    -a, --admin-root URL      URL of Admin REST endpoint root if not default - e.g. http://localhost:8080/admin");
        out.println("    -r, --target-realm REALM  Target realm to issue requests against if not the one authenticated against");
        out.println();
        out.println("Examples:");
        out.println();
        out.println("Get all realm roles defined on a realm:");
        out.println("  " + OsUtil.PROMPT + " " + KcAdmMain.CMD + " get-roles -r demorealm");
        out.println();
        out.println("Get all client roles defined on a specific client, displaying only 'id' and 'name':");
        out.println("  " + OsUtil.PROMPT + " " + KcAdmMain.CMD + " get-roles -r demorealm --cclientid realm-management --fields id,name");
        out.println();
        out.println("List all realm roles for a specific user:");
        out.println("  " + OsUtil.PROMPT + " " + KcAdmMain.CMD + " get-roles -r demorealm --uusername testuser");
        out.println();
        out.println("List effective client roles for 'realm-management' client for a specific user:");
        out.println("  " + OsUtil.PROMPT + " " + KcAdmMain.CMD + " get-roles -r demorealm --uusername testuser --cclientid realm-management --effective");
        out.println();
        out.println();
        out.println("Use '" + KcAdmMain.CMD + " help' for general information and a list of commands");
        return sb.toString();
    }
}

