/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.util;

import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;

public final class AggregatedClassLoader
extends ClassLoader {
    private final ClassLoader[] classLoaders;

    public AggregatedClassLoader(Collection<ClassLoader> classLoaders) {
        super(null);
        if (classLoaders == null || classLoaders.isEmpty()) {
            throw new IllegalArgumentException("classLoaders argument cannot be null or empty");
        }
        this.classLoaders = classLoaders.toArray(new ClassLoader[classLoaders.size()]);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        final HashSet<URL> urls = new HashSet<URL>();
        for (ClassLoader cl : this.classLoaders) {
            Enumeration<URL> resources = cl.getResources(name);
            while (resources.hasMoreElements()) {
                urls.add(resources.nextElement());
            }
        }
        return new Enumeration<URL>(){
            final Iterator<URL> it;
            final /* synthetic */ AggregatedClassLoader this$0;
            {
                this.this$0 = this$0;
                this.it = urls.iterator();
            }

            @Override
            public boolean hasMoreElements() {
                return this.it.hasNext();
            }

            @Override
            public URL nextElement() {
                return this.it.next();
            }
        };
    }

    @Override
    protected URL findResource(String name) {
        for (ClassLoader cl : this.classLoaders) {
            URL res = cl.getResource(name);
            if (res == null) continue;
            return res;
        }
        return super.findResource(name);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        for (ClassLoader cl : this.classLoaders) {
            try {
                return cl.loadClass(name);
            }
            catch (Exception exception) {
            }
        }
        throw new ClassNotFoundException(name);
    }
}

