/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.dataconversion;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Optional;
import org.infinispan.commons.dataconversion.Base16Codec;
import org.infinispan.commons.dataconversion.EncodingException;
import org.infinispan.commons.dataconversion.JavaStringCodec;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.MediaTypeCodec;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.logging.LogFactory;

class RFC4648Codec
implements MediaTypeCodec {
    private static final Log log = LogFactory.getLog(RFC4648Codec.class);

    RFC4648Codec() {
    }

    @Override
    public Object decodeContent(Object content, MediaType contentType) {
        Optional<String> optionalEncoding = contentType.getParameter("encoding");
        if (optionalEncoding.isPresent()) {
            String enc = optionalEncoding.get();
            if (content instanceof byte[]) {
                return this.decode(new String((byte[])content, contentType.getCharset()), enc);
            }
            if (content instanceof String) {
                return this.decode(content.toString(), enc);
            }
            throw new EncodingException("Cannot decode binary content " + String.valueOf(content));
        }
        if (content instanceof String && (contentType.match(MediaType.APPLICATION_OCTET_STREAM) || this.hasJavaByteArrayType(contentType))) {
            return this.decode(content.toString(), "hex");
        }
        return content;
    }

    private boolean hasJavaByteArrayType(MediaType contentType) {
        return contentType.match(MediaType.APPLICATION_OBJECT) && contentType.getClassType() != null && contentType.getClassType().equals(JavaStringCodec.BYTE_ARRAY.getName());
    }

    private Object decode(String content, String codec) {
        switch (codec) {
            case "hex": {
                return Base16Codec.decode(content);
            }
            case "base64": {
                return Base64.getDecoder().decode(content);
            }
        }
        throw log.encodingNotSupported(codec);
    }

    private Object encode(byte[] content, String codec) {
        switch (codec) {
            case "hex": {
                return Base16Codec.encode(content);
            }
            case "base64": {
                return Base64.getEncoder().encode(content);
            }
        }
        throw log.encodingNotSupported(codec);
    }

    @Override
    public Object encodeContent(Object content, MediaType destinationType) {
        Optional<String> optionalEncoding = destinationType.getParameter("encoding");
        if (optionalEncoding.isPresent()) {
            String enc = optionalEncoding.get();
            if (content instanceof byte[]) {
                content = this.encode((byte[])content, enc);
            } else if (content instanceof String) {
                content = this.encode(content.toString().getBytes(StandardCharsets.UTF_8), enc);
            }
            return content;
        }
        boolean binaryTargetForString = destinationType.isBinary() && content instanceof String;
        return binaryTargetForString ? (Object)content.toString().getBytes(StandardCharsets.UTF_8) : content;
    }
}

