/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.deployment.spi;

import io.quarkus.builder.item.MultiBuildItem;
import java.nio.file.Path;
import java.util.Objects;

public final class GeneratedStaticResourceBuildItem
extends MultiBuildItem {
    private final String endpoint;
    private final Path file;
    private final byte[] content;

    private GeneratedStaticResourceBuildItem(String endpoint, byte[] content, Path file) {
        Objects.requireNonNull(endpoint, "endpoint is required");
        if (!endpoint.startsWith("/")) {
            throw new IllegalArgumentException("GeneratedStaticResourceBuildItem endpoint must start with '/': %s".formatted(endpoint));
        }
        if (endpoint.endsWith("/")) {
            throw new IllegalArgumentException("GeneratedStaticResourceBuildItem endpoint must not end with '/': %s".formatted(endpoint));
        }
        this.endpoint = endpoint;
        this.file = file;
        this.content = content;
    }

    public GeneratedStaticResourceBuildItem(String endpoint, byte[] content) {
        this(endpoint, content, null);
    }

    public GeneratedStaticResourceBuildItem(String endpoint, Path file) {
        this(endpoint, null, file);
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public boolean isFile() {
        return this.file != null;
    }

    public byte[] getContent() {
        return this.content;
    }

    public Path getFile() {
        return this.file;
    }

    public String getFileAbsolutePath() {
        return this.file.toAbsolutePath().toString();
    }
}

