/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.events;

import org.jboss.logging.Logger;
import org.keycloak.cluster.ClusterEvent;
import org.keycloak.cluster.ClusterListener;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.sessions.infinispan.events.SessionClusterEvent;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.provider.Provider;

public abstract class AbstractUserSessionClusterListener<SE extends SessionClusterEvent, T extends Provider>
implements ClusterListener {
    private static final Logger log = Logger.getLogger(AbstractUserSessionClusterListener.class);
    private final KeycloakSessionFactory sessionFactory;
    private final Class<T> providerClazz;

    public AbstractUserSessionClusterListener(KeycloakSessionFactory sessionFactory, Class<T> providerClazz) {
        this.sessionFactory = sessionFactory;
        this.providerClazz = providerClazz;
    }

    public void eventReceived(ClusterEvent event) {
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)this.sessionFactory, session -> {
            Provider provider = session.getProvider(this.providerClazz);
            SessionClusterEvent sessionEvent = (SessionClusterEvent)event;
            if (log.isDebugEnabled()) {
                log.debugf("Received user session event '%s'.", (Object)sessionEvent.toString());
            }
            this.eventReceived(provider, sessionEvent);
        });
    }

    protected abstract void eventReceived(T var1, SE var2);
}

