/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan.events;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.keycloak.cluster.ClusterEvent;

@ProtoTypeId(value=65574)
public class AuthenticationSessionAuthNoteUpdateEvent
implements ClusterEvent {
    private final String authSessionId;
    private final String tabId;
    private final Map<String, String> authNotesFragment;

    private AuthenticationSessionAuthNoteUpdateEvent(Map<String, String> authNotesFragment, String authSessionId, String tabId) {
        this.authNotesFragment = Objects.requireNonNull(authNotesFragment);
        this.authSessionId = Objects.requireNonNull(authSessionId);
        this.tabId = Objects.requireNonNull(tabId);
    }

    @ProtoFactory
    public static AuthenticationSessionAuthNoteUpdateEvent create(String authSessionId, String tabId, Map<String, String> authNotesFragment) {
        return new AuthenticationSessionAuthNoteUpdateEvent(authNotesFragment, authSessionId, tabId);
    }

    @ProtoField(value=1)
    public String getAuthSessionId() {
        return this.authSessionId;
    }

    @ProtoField(value=2)
    public String getTabId() {
        return this.tabId;
    }

    @ProtoField(value=3, mapImplementation=LinkedHashMap.class)
    public Map<String, String> getAuthNotesFragment() {
        return this.authNotesFragment;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthenticationSessionAuthNoteUpdateEvent that = (AuthenticationSessionAuthNoteUpdateEvent)o;
        return Objects.equals(this.authSessionId, that.authSessionId) && Objects.equals(this.tabId, that.tabId);
    }

    public int hashCode() {
        return Objects.hash(this.authSessionId, this.tabId);
    }

    public String toString() {
        return String.format("AuthenticationSessionAuthNoteUpdateEvent [ authSessionId=%s, tabId=%s, authNotesFragment=%s ]", this.authSessionId, this.tabId, this.authNotesFragment);
    }
}

