/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.key;

import java.math.BigInteger;
import java.security.Key;
import java.security.interfaces.RSAMultiPrimePrivateCrtKey;
import java.security.spec.RSAOtherPrimeInfo;
import java.util.Arrays;
import java.util.Objects;
import org.wildfly.security.key.RawRSAPrivateKey;

class RawRSAMultiPrimePrivateCrtKey
extends RawRSAPrivateKey
implements RSAMultiPrimePrivateCrtKey {
    private static final long serialVersionUID = 6636285660549509254L;
    private final BigInteger publicExponent;
    private final BigInteger primeP;
    private final BigInteger primeQ;
    private final BigInteger primeExponentP;
    private final BigInteger primeExponentQ;
    private final BigInteger crtCoefficient;
    private final RSAOtherPrimeInfo[] otherPrimeInfo;

    RawRSAMultiPrimePrivateCrtKey(RSAMultiPrimePrivateCrtKey original) {
        super(original);
        this.publicExponent = original.getPublicExponent();
        this.primeP = original.getPrimeP();
        this.primeQ = original.getPrimeQ();
        this.primeExponentP = original.getPrimeExponentP();
        this.primeExponentQ = original.getPrimeExponentQ();
        this.crtCoefficient = original.getCrtCoefficient();
        RSAOtherPrimeInfo[] otherPrimeInfo = original.getOtherPrimeInfo();
        this.otherPrimeInfo = otherPrimeInfo == null ? null : (RSAOtherPrimeInfo[])otherPrimeInfo.clone();
    }

    RawRSAMultiPrimePrivateCrtKey(Key original) {
        this((RSAMultiPrimePrivateCrtKey)original);
    }

    @Override
    public BigInteger getPublicExponent() {
        return this.publicExponent;
    }

    @Override
    public BigInteger getPrimeP() {
        return this.primeP;
    }

    @Override
    public BigInteger getPrimeQ() {
        return this.primeQ;
    }

    @Override
    public BigInteger getPrimeExponentP() {
        return this.primeExponentP;
    }

    @Override
    public BigInteger getPrimeExponentQ() {
        return this.primeExponentQ;
    }

    @Override
    public BigInteger getCrtCoefficient() {
        return this.crtCoefficient;
    }

    @Override
    public RSAOtherPrimeInfo[] getOtherPrimeInfo() {
        RSAOtherPrimeInfo[] otherPrimeInfo = this.otherPrimeInfo;
        return otherPrimeInfo == null ? null : (RSAOtherPrimeInfo[])otherPrimeInfo.clone();
    }

    @Override
    boolean isEqual(Key key) {
        return key instanceof RSAMultiPrimePrivateCrtKey && this.isEqual((RSAMultiPrimePrivateCrtKey)key);
    }

    boolean isEqual(RSAMultiPrimePrivateCrtKey key) {
        return super.isEqual(key) && Objects.equals(this.publicExponent, key.getPublicExponent()) && Objects.equals(this.primeP, key.getPrimeP()) && Objects.equals(this.primeQ, key.getPrimeQ()) && Objects.equals(this.primeExponentP, key.getPrimeExponentP()) && Objects.equals(this.primeExponentQ, key.getPrimeExponentQ()) && Objects.equals(this.crtCoefficient, key.getCrtCoefficient()) && Arrays.deepEquals(this.otherPrimeInfo, key.getOtherPrimeInfo());
    }
}

