/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.certs.pem.parsers;

import io.smallrye.certs.pem.der.DerEncoder;
import io.smallrye.certs.pem.parsers.PKPemParser;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PKCS1Parser
implements PKPemParser {
    private static final String PKCS1_RSA_START = "-+BEGIN\\s+RSA\\s+PRIVATE\\s+KEY[^-]*-+(?:\\s|\\r|\\n)+";
    private static final String PKCS1_RSA_END = "-+END\\s+RSA\\s+PRIVATE\\s+KEY[^-]*-+";
    private static final Pattern PKCS1_PATTERN = Pattern.compile("-+BEGIN\\s+RSA\\s+PRIVATE\\s+KEY[^-]*-+(?:\\s|\\r|\\n)+([a-z0-9+/=\\r\\n]+)-+END\\s+RSA\\s+PRIVATE\\s+KEY[^-]*-+", 2);

    @Override
    public PrivateKey getKey(String content, String ignored) {
        try {
            Matcher matcher = PKCS1_PATTERN.matcher(content);
            if (matcher.find()) {
                String encoded = matcher.group(1);
                byte[] decoded = this.decodeBase64(encoded);
                return this.extract(decoded);
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    private PrivateKey extract(byte[] decoded) {
        try {
            DerEncoder encoder = new DerEncoder();
            encoder.integer(0);
            DerEncoder algorithmIdentifier = new DerEncoder();
            algorithmIdentifier.oid(RSA_ALGORITHM);
            algorithmIdentifier.oid(null);
            encoder.sequence(algorithmIdentifier.toBytes());
            encoder.octetString(decoded);
            PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(encoder.toSequence());
            return KeyFactory.getInstance("RSA").generatePrivate(spec);
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }
}

