/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.api;

import io.undertow.servlet.api.SecurityInfo;
import io.undertow.servlet.api.WebResourceCollection;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SecurityConstraint
extends SecurityInfo<SecurityConstraint> {
    private final Set<WebResourceCollection> webResourceCollections = new HashSet<WebResourceCollection>();

    public Set<WebResourceCollection> getWebResourceCollections() {
        return Collections.unmodifiableSet(this.webResourceCollections);
    }

    public SecurityConstraint addWebResourceCollection(WebResourceCollection webResourceCollection) {
        this.webResourceCollections.add(webResourceCollection);
        return this;
    }

    public SecurityConstraint addWebResourceCollections(WebResourceCollection ... webResourceCollection) {
        this.webResourceCollections.addAll(Arrays.asList(webResourceCollection));
        return this;
    }

    public SecurityConstraint addWebResourceCollections(List<WebResourceCollection> webResourceCollections) {
        this.webResourceCollections.addAll(webResourceCollections);
        return this;
    }

    @Override
    protected SecurityConstraint createInstance() {
        return new SecurityConstraint();
    }

    @Override
    public SecurityConstraint clone() {
        SecurityConstraint info = (SecurityConstraint)super.clone();
        for (WebResourceCollection wr : this.webResourceCollections) {
            info.addWebResourceCollection(wr.clone());
        }
        return info;
    }
}

