/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.sdjwt.consumer;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.keycloak.common.VerificationException;
import org.keycloak.sdjwt.consumer.PresentationRequirements;

public class SimplePresentationDefinition
implements PresentationRequirements {
    private final Map<String, Pattern> requirements;

    public SimplePresentationDefinition(Map<String, Pattern> requirements) {
        this.requirements = requirements;
    }

    @Override
    public void checkIfSatisfiedBy(JsonNode disclosedPayload) throws VerificationException {
        for (Map.Entry<String, Pattern> requirement : this.requirements.entrySet()) {
            String field = requirement.getKey();
            Pattern pattern = requirement.getValue();
            JsonNode presented = disclosedPayload.get(field);
            if (presented == null || presented.isNull()) {
                throw new VerificationException(String.format("A required field was not presented: `%s`", field));
            }
            String json = presented.toString();
            Matcher matcher = pattern.matcher(json);
            if (matcher.matches()) continue;
            throw new VerificationException(String.format("Pattern matching failed for required field: `%s`. Expected pattern: /%s/, but got: %s", field, pattern.pattern(), json));
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final Map<String, Pattern> requirements = new HashMap<String, Pattern>();

        public Builder addClaimRequirement(String field, String regexPattern) {
            this.requirements.put(field, Pattern.compile(regexPattern));
            return this;
        }

        public SimplePresentationDefinition build() {
            return new SimplePresentationDefinition(this.requirements);
        }
    }
}

