/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.security.impl;

import io.undertow.util.HeaderToken;
import io.undertow.util.HeaderTokenParser;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public enum DigestWWWAuthenticateToken implements HeaderToken
{
    REALM("realm", true),
    DOMAIN("domain", true),
    NONCE("nonce", true),
    OPAQUE("opaque", true),
    STALE("stale", false),
    ALGORITHM("algorithm", false),
    MESSAGE_QOP("qop", true),
    AUTH_PARAM("auth-param", false);

    private static final HeaderTokenParser<DigestWWWAuthenticateToken> TOKEN_PARSER;
    private final String name;
    private final boolean quoted;

    private DigestWWWAuthenticateToken(String name, boolean quoted) {
        this.name = name.toString();
        this.quoted = quoted;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isAllowQuoted() {
        return this.quoted;
    }

    public static Map<DigestWWWAuthenticateToken, String> parseHeader(String header) {
        return TOKEN_PARSER.parseHeader(header);
    }

    static {
        LinkedHashMap<String, DigestWWWAuthenticateToken> expected = new LinkedHashMap<String, DigestWWWAuthenticateToken>(DigestWWWAuthenticateToken.values().length);
        for (DigestWWWAuthenticateToken current : DigestWWWAuthenticateToken.values()) {
            expected.put(current.getName(), current);
        }
        TOKEN_PARSER = new HeaderTokenParser(Collections.unmodifiableMap(expected));
    }
}

