/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo2.impl.constant;

import io.quarkus.gizmo2.impl.constant.ConstImpl;
import io.quarkus.gizmo2.impl.constant.MethodHandleConst;
import java.lang.constant.Constable;
import java.lang.constant.ConstantDesc;
import java.lang.constant.ConstantDescs;
import java.lang.constant.DynamicConstantDesc;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;

public final class InvokeConst
extends ConstImpl {
    private final MethodHandleConst handleConstant;
    private final List<ConstImpl> args;

    InvokeConst(MethodHandleConst handleConstant, List<ConstImpl> args) {
        super(handleConstant.desc().invocationType().returnType());
        this.handleConstant = handleConstant;
        this.args = args;
    }

    @Override
    public boolean equals(ConstImpl obj) {
        InvokeConst other;
        return obj instanceof InvokeConst && this.equals(other = (InvokeConst)obj);
    }

    public boolean equals(InvokeConst other) {
        return this == other || other != null && this.handleConstant.equals(other.handleConstant) && this.args.equals(other.args);
    }

    @Override
    public int hashCode() {
        return this.handleConstant.hashCode() * 19 + this.args.hashCode();
    }

    @Override
    public ConstantDesc desc() {
        return DynamicConstantDesc.of(ConstantDescs.BSM_INVOKE, (ConstantDesc[])Stream.concat(Stream.of(this.handleConstant.desc()), this.args.stream().map(Constable::describeConstable).map(Optional::orElseThrow)).toArray(ConstantDesc[]::new));
    }

    @Override
    public Optional<? extends ConstantDesc> describeConstable() {
        return Optional.of(this.desc());
    }

    @Override
    public StringBuilder toShortString(StringBuilder b) {
        b.append("Invoke[");
        this.handleConstant.toShortString(b).append("](");
        Iterator<ConstImpl> iterator = this.args.iterator();
        if (iterator.hasNext()) {
            this.handleConstant.toShortString(b);
            while (iterator.hasNext()) {
                b.append(',');
                this.handleConstant.toShortString(b);
            }
        }
        return b.append(')');
    }
}

